/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.style;

import cn.taketoday.core.style.DefaultToStringStyler;
import cn.taketoday.core.style.DefaultValueStyler;
import cn.taketoday.core.style.ToStringStyler;
import cn.taketoday.core.style.ValueStyler;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;

public class ToStringBuilder {
    static final DefaultValueStyler DEFAULT_VALUE_STYLER = new DefaultValueStyler();
    private static final ToStringStyler DEFAULT_TO_STRING_STYLER = new DefaultToStringStyler(DEFAULT_VALUE_STYLER);
    private final StringBuilder buffer = new StringBuilder(256);
    private final ToStringStyler styler;
    private final Object object;
    private boolean styledFirstField;

    public ToStringBuilder(Object obj) {
        this(obj, (ToStringStyler)null);
    }

    public ToStringBuilder(Object obj, @Nullable ValueStyler styler) {
        this(obj, new DefaultToStringStyler(styler != null ? styler : DEFAULT_VALUE_STYLER));
    }

    public ToStringBuilder(Object obj, @Nullable ToStringStyler styler) {
        Assert.notNull(obj, "The object to be styled must not be null");
        this.object = obj;
        this.styler = styler != null ? styler : DEFAULT_TO_STRING_STYLER;
        this.styler.styleStart(this.buffer, this.object);
    }

    public ToStringBuilder append(String fieldName, byte value) {
        return this.append(fieldName, (Object)value);
    }

    public ToStringBuilder append(String fieldName, short value) {
        return this.append(fieldName, (Object)value);
    }

    public ToStringBuilder append(String fieldName, int value) {
        return this.append(fieldName, (Object)value);
    }

    public ToStringBuilder append(String fieldName, long value) {
        return this.append(fieldName, (Object)value);
    }

    public ToStringBuilder append(String fieldName, float value) {
        return this.append(fieldName, Float.valueOf(value));
    }

    public ToStringBuilder append(String fieldName, double value) {
        return this.append(fieldName, (Object)value);
    }

    public ToStringBuilder append(String fieldName, boolean value) {
        return this.append(fieldName, (Object)value);
    }

    public ToStringBuilder append(String fieldName, @Nullable Object value) {
        this.printFieldSeparatorIfNecessary();
        this.styler.styleField(this.buffer, fieldName, value);
        return this;
    }

    private void printFieldSeparatorIfNecessary() {
        if (this.styledFirstField) {
            this.styler.styleFieldSeparator(this.buffer);
        } else {
            this.styledFirstField = true;
        }
    }

    public ToStringBuilder append(Object value) {
        this.styler.styleValue(this.buffer, value);
        return this;
    }

    public String toString() {
        this.styler.styleEnd(this.buffer, this.object);
        return this.buffer.toString();
    }

    public static ToStringBuilder from(Object obj) {
        return new ToStringBuilder(obj);
    }
}

