/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.serializer.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.serializer.DefaultSerializer;
import cn.taketoday.core.serializer.Serializer;
import cn.taketoday.core.serializer.support.SerializationFailedException;
import cn.taketoday.lang.Assert;

public class SerializingConverter
implements Converter<Object, byte[]> {
    private final Serializer<Object> serializer;

    public SerializingConverter() {
        this.serializer = new DefaultSerializer();
    }

    public SerializingConverter(Serializer<Object> serializer) {
        Assert.notNull(serializer, "Serializer must not be null");
        this.serializer = serializer;
    }

    @Override
    public byte[] convert(Object source) {
        try {
            return this.serializer.serializeToByteArray(source);
        }
        catch (Throwable ex) {
            throw new SerializationFailedException("Failed to serialize object using " + this.serializer.getClass().getSimpleName(), ex);
        }
    }
}

