/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io.buffer;

import cn.taketoday.core.io.buffer.DataBufferFactory;
import cn.taketoday.core.io.buffer.DataBufferInputStream;
import cn.taketoday.core.io.buffer.DataBufferOutputStream;
import cn.taketoday.core.io.buffer.DataBufferUtils;
import cn.taketoday.lang.Assert;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.function.IntPredicate;

public interface DataBuffer {
    public DataBufferFactory factory();

    public int indexOf(IntPredicate var1, int var2);

    public int lastIndexOf(IntPredicate var1, int var2);

    public int readableByteCount();

    public int writableByteCount();

    public int capacity();

    @Deprecated
    public DataBuffer capacity(int var1);

    @Deprecated
    default public DataBuffer ensureCapacity(int capacity) {
        return this.ensureWritable(capacity);
    }

    public DataBuffer ensureWritable(int var1);

    public int readPosition();

    public DataBuffer readPosition(int var1);

    public int writePosition();

    public DataBuffer writePosition(int var1);

    public byte getByte(int var1);

    public byte read();

    public DataBuffer read(byte[] var1);

    public DataBuffer read(byte[] var1, int var2, int var3);

    public DataBuffer write(byte var1);

    public DataBuffer write(byte[] var1);

    public DataBuffer write(byte[] var1, int var2, int var3);

    public DataBuffer write(DataBuffer ... var1);

    public DataBuffer write(ByteBuffer ... var1);

    default public DataBuffer write(CharSequence charSequence, Charset charset) {
        Assert.notNull((Object)charSequence, "CharSequence must not be null");
        Assert.notNull((Object)charset, "Charset must not be null");
        if (charSequence.length() != 0) {
            CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            CharBuffer inBuffer = CharBuffer.wrap(charSequence);
            int estimatedSize = (int)((float)inBuffer.remaining() * charsetEncoder.averageBytesPerChar());
            ByteBuffer outBuffer = this.ensureCapacity(estimatedSize).asByteBuffer(this.writePosition(), this.writableByteCount());
            while (true) {
                CoderResult cr;
                CoderResult coderResult = cr = inBuffer.hasRemaining() ? charsetEncoder.encode(inBuffer, outBuffer, true) : CoderResult.UNDERFLOW;
                if (cr.isUnderflow()) {
                    cr = charsetEncoder.flush(outBuffer);
                }
                if (cr.isUnderflow()) break;
                if (!cr.isOverflow()) continue;
                this.writePosition(this.writePosition() + outBuffer.position());
                int maximumSize = (int)((float)inBuffer.remaining() * charsetEncoder.maxBytesPerChar());
                this.ensureCapacity(maximumSize);
                outBuffer = this.asByteBuffer(this.writePosition(), this.writableByteCount());
            }
            this.writePosition(this.writePosition() + outBuffer.position());
        }
        return this;
    }

    @Deprecated
    public DataBuffer slice(int var1, int var2);

    @Deprecated
    default public DataBuffer retainedSlice(int index, int length) {
        return DataBufferUtils.retain(this.slice(index, length));
    }

    public DataBuffer split(int var1);

    @Deprecated
    public ByteBuffer asByteBuffer();

    @Deprecated
    public ByteBuffer asByteBuffer(int var1, int var2);

    default public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(this.readPosition(), this.readableByteCount());
    }

    public ByteBuffer toByteBuffer(int var1, int var2);

    default public InputStream asInputStream() {
        return new DataBufferInputStream(this, false);
    }

    default public InputStream asInputStream(boolean releaseOnClose) {
        return new DataBufferInputStream(this, releaseOnClose);
    }

    default public OutputStream asOutputStream() {
        return new DataBufferOutputStream(this);
    }

    default public String toString(Charset charset) {
        Assert.notNull((Object)charset, "Charset must not be null");
        return this.toString(this.readPosition(), this.readableByteCount(), charset);
    }

    public String toString(int var1, int var2, Charset var3);
}

