/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceDecorator;
import cn.taketoday.core.io.WritableResource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.WritableByteChannel;

public class WritableResourceDecorator
extends ResourceDecorator
implements WritableResource {
    protected WritableResourceDecorator() {
    }

    public WritableResourceDecorator(Resource delegate) {
        super(delegate);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.writableResource().getOutputStream();
    }

    @Override
    public Writer getWriter() throws IOException {
        return this.writableResource().getWriter();
    }

    @Override
    public WritableByteChannel writableChannel() throws IOException {
        return this.writableResource().writableChannel();
    }

    @Override
    public boolean isWritable() {
        return this.writableResource().isWritable();
    }

    protected WritableResource writableResource() {
        Resource delegate = this.getDelegate();
        if (delegate instanceof WritableResource) {
            WritableResource writableResource = (WritableResource)delegate;
            return writableResource;
        }
        throw new UnsupportedOperationException("Writable operation is not supported");
    }
}

