/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.AbstractResource;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceFilter;
import cn.taketoday.core.io.WritableResource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ResourceUtils;
import cn.taketoday.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;

public class FileSystemResource
extends AbstractResource
implements WritableResource {
    @Nullable
    private final File file;
    private final String path;
    private final Path filePath;

    public FileSystemResource(String path) {
        Assert.notNull((Object)path, "Path must not be null");
        this.path = StringUtils.cleanPath(path);
        this.file = new File(path);
        this.filePath = this.file.toPath();
    }

    public FileSystemResource(File file) {
        this.file = file;
        this.filePath = file.toPath();
        this.path = StringUtils.cleanPath(file.getPath());
    }

    public FileSystemResource(Path filePath) {
        this.file = null;
        this.filePath = filePath;
        this.path = StringUtils.cleanPath(filePath.toString());
    }

    public FileSystemResource(FileSystem fileSystem, String path) {
        Assert.notNull((Object)path, "Path must not be null");
        Assert.notNull((Object)fileSystem, "FileSystem must not be null");
        this.file = null;
        this.path = StringUtils.cleanPath(path);
        this.filePath = fileSystem.getPath(this.path, new String[0]).normalize();
    }

    public final String getPath() {
        return this.path;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public boolean exists() {
        return this.file != null ? this.file.exists() : Files.exists(this.filePath, new LinkOption[0]);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return Files.newInputStream(this.filePath, new OpenOption[0]);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.filePath, new OpenOption[0]);
    }

    @Override
    public URL getURL() throws IOException {
        return this.file != null ? this.file.toURI().toURL() : this.filePath.toUri().toURL();
    }

    @Override
    public URI getURI() throws IOException {
        if (this.file != null) {
            return this.file.toURI();
        }
        URI uri = this.filePath.toUri();
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            try {
                uri = new URI(scheme, uri.getPath(), null);
            }
            catch (URISyntaxException ex) {
                throw new IOException("Failed to normalize URI: " + uri, ex);
            }
        }
        return uri;
    }

    @Override
    public File getFile() {
        return this.file != null ? this.file : this.filePath.toFile();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDirectory() throws IOException {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        return Files.isDirectory(this.filePath, new LinkOption[0]);
    }

    @Override
    public long contentLength() throws IOException {
        if (this.file != null) {
            long length = this.file.length();
            if (length == 0L && !this.file.exists()) {
                throw new FileNotFoundException(this.getName() + " cannot be resolved its content length");
            }
            return length;
        }
        try {
            return Files.size(this.filePath);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public long lastModified() throws IOException {
        if (this.file != null) {
            return super.lastModified();
        }
        try {
            return Files.getLastModifiedTime(this.filePath, new LinkOption[0]).toMillis();
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        String pathToUse = ResourceUtils.getRelativePath(this.path, relativePath);
        return this.file != null ? new FileSystemResource(pathToUse) : new FileSystemResource(this.filePath.getFileSystem(), pathToUse);
    }

    @Override
    public String[] list() throws IOException {
        if (this.file != null) {
            return this.file.list();
        }
        return this.filePath.toFile().list();
    }

    @Override
    public Resource[] list(ResourceFilter filter) throws IOException {
        Object[] names = this.list();
        if (ObjectUtils.isEmpty(names)) {
            return EMPTY_ARRAY;
        }
        File parent = this.getFile();
        ArrayList<FileSystemResource> resources = new ArrayList<FileSystemResource>(names.length);
        for (Object name : names) {
            FileSystemResource resource = new FileSystemResource(new File(parent, (String)name));
            if (filter != null && !filter.accept(resource)) continue;
            resources.add(resource);
        }
        if (resources.isEmpty()) {
            return EMPTY_ARRAY;
        }
        return resources.toArray(Resource.EMPTY_ARRAY);
    }

    @Override
    public String getName() {
        Path fileName;
        if (this.file != null) {
            return this.file.getName();
        }
        if (this.filePath != null && (fileName = this.filePath.getFileName()) != null) {
            return fileName.toString();
        }
        return new File(this.path).getName();
    }

    @Override
    public ReadableByteChannel readableChannel() throws IOException {
        try {
            return FileChannel.open(this.filePath, StandardOpenOption.READ);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }

    @Override
    public WritableByteChannel writableChannel() throws IOException {
        return FileChannel.open(this.filePath, StandardOpenOption.WRITE);
    }

    @Override
    public boolean isReadable() {
        return this.file != null ? this.file.canRead() && !this.file.isDirectory() : Files.isReadable(this.filePath) && !Files.isDirectory(this.filePath, new LinkOption[0]);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof FileSystemResource && this.path.equals(((FileSystemResource)other).path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        return "FileSystemResource: ".concat(this.path);
    }
}

