/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.InputStreamSource;
import cn.taketoday.core.io.Resource;
import cn.taketoday.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;

public class EncodedResource
implements InputStreamSource {
    private final String encoding;
    private final Charset charset;
    private final Resource resource;

    public EncodedResource(Resource resource) {
        this(resource, null, null);
    }

    public EncodedResource(Resource resource, String encoding) {
        this(resource, encoding, null);
    }

    public EncodedResource(Resource resource, Charset charset) {
        this(resource, null, charset);
    }

    private EncodedResource(Resource resource, String encoding, Charset charset) {
        Assert.notNull((Object)resource, "Resource must not be null");
        this.resource = resource;
        this.encoding = encoding;
        this.charset = charset;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final Charset getCharset() {
        return this.charset;
    }

    public boolean requiresReader() {
        return this.encoding != null || this.charset != null;
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.charset != null) {
            return new InputStreamReader(this.resource.getInputStream(), this.charset);
        }
        if (this.encoding != null) {
            return new InputStreamReader(this.resource.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.resource.getInputStream());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncodedResource)) {
            return false;
        }
        EncodedResource otherResource = (EncodedResource)other;
        return this.resource.equals(otherResource.resource) && Objects.equals(this.charset, otherResource.charset) && Objects.equals(this.encoding, otherResource.encoding);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public String toString() {
        return this.resource.toString();
    }
}

