/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.io;

import cn.taketoday.core.io.AbstractFileResolvingResource;
import cn.taketoday.core.io.FileSystemResource;
import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceFilter;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ResourceUtils;
import cn.taketoday.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ClassPathResource
extends AbstractFileResolvingResource {
    private final String path;
    private final String absolutePath;
    private Class<?> resourceClass;
    private ClassLoader classLoader;
    protected Resource delegate;

    public ClassPathResource(String path) {
        this(path, ClassUtils.getDefaultClassLoader());
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        Assert.notNull((Object)path, "Path must not be null");
        String pathToUse = StringUtils.cleanPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.absolutePath = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassPathResource(String path, Class<?> clazz) {
        Assert.notNull((Object)path, "Path must not be null");
        this.path = StringUtils.cleanPath(path);
        Object absolutePath = this.path;
        if (clazz != null && !((String)absolutePath).startsWith("/")) {
            absolutePath = ClassUtils.classPackageAsResourcePath(clazz) + "/" + (String)absolutePath;
        } else if (((String)absolutePath).startsWith("/")) {
            absolutePath = ((String)absolutePath).substring(1);
        }
        this.absolutePath = absolutePath;
        this.resourceClass = clazz;
    }

    public final Resource getDelegate() {
        if (this.delegate == null) {
            URL url = this.resourceClass != null ? this.resourceClass.getResource(this.path) : (this.classLoader != null ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
            this.delegate = url != null ? ResourceUtils.getResource(url) : new FileSystemResource(this.path);
        }
        return this.delegate;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.resolveURL();
        if (url == null) {
            throw new FileNotFoundException(this + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    @Override
    public boolean exists() {
        return this.resolveURL() != null;
    }

    @Override
    public boolean isReadable() {
        URL url = this.resolveURL();
        return url != null && this.checkReadable(url);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.resourceClass != null ? this.resourceClass.getResourceAsStream(this.path) : (this.classLoader != null ? this.classLoader.getResourceAsStream(this.absolutePath) : ClassLoader.getSystemResourceAsStream(this.absolutePath));
        if (is == null) {
            throw new FileNotFoundException(this + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Nullable
    protected URL resolveURL() {
        try {
            if (this.resourceClass != null) {
                return this.resourceClass.getResource(this.path);
            }
            if (this.classLoader != null) {
                return this.classLoader.getResource(this.absolutePath);
            }
            return ClassLoader.getSystemResource(this.absolutePath);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public boolean isDirectory() throws IOException {
        return this.getDelegate().isDirectory();
    }

    @Override
    public Resource[] list(ResourceFilter filter) throws IOException {
        return this.getDelegate().list(filter);
    }

    @Override
    public String[] list() throws IOException {
        return this.getDelegate().list();
    }

    @Override
    public String getName() {
        return StringUtils.getFilename(this.absolutePath);
    }

    @Override
    public Resource createRelative(String relativePath) {
        String pathToUse = ResourceUtils.getRelativePath(this.path, relativePath);
        return this.resourceClass != null ? new ClassPathResource(pathToUse, this.resourceClass) : new ClassPathResource(pathToUse, this.classLoader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassPathResource)) return false;
        ClassPathResource other = (ClassPathResource)obj;
        if (!this.absolutePath.equals(other.absolutePath)) return false;
        if (!ObjectUtils.nullSafeEquals(this.getClassLoader(), other.getClassLoader())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.absolutePath.hashCode();
    }

    public final Resource getOriginalResource() {
        return this.getDelegate();
    }

    @Nullable
    public final ClassLoader getClassLoader() {
        return this.resourceClass != null ? this.resourceClass.getClassLoader() : this.classLoader;
    }

    public final String getPath() {
        return this.absolutePath;
    }

    @Override
    public String toString() {
        return "class path resource [" + this.absolutePath + "]";
    }
}

