/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.env;

import cn.taketoday.core.env.MapPropertySource;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import java.util.Map;

public class SystemEnvironmentPropertySource
extends MapPropertySource {
    private static final Logger log = LoggerFactory.getLogger(SystemEnvironmentPropertySource.class);

    public SystemEnvironmentPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    @Override
    public boolean containsProperty(String name) {
        return this.getProperty(name) != null;
    }

    @Override
    @Nullable
    public Object getProperty(String name) {
        String actualName = this.resolvePropertyName(name);
        if (log.isDebugEnabled() && !name.equals(actualName)) {
            log.debug("PropertySource '{}' does not contain property '{}', but found equivalent '{}'", this.getName(), name, actualName);
        }
        return super.getProperty(actualName);
    }

    protected final String resolvePropertyName(String name) {
        Assert.notNull((Object)name, "Property name must not be null");
        String resolvedName = this.checkPropertyName(name);
        if (resolvedName != null) {
            return resolvedName;
        }
        String uppercasedName = name.toUpperCase();
        if (!name.equals(uppercasedName) && (resolvedName = this.checkPropertyName(uppercasedName)) != null) {
            return resolvedName;
        }
        return name;
    }

    @Nullable
    private String checkPropertyName(String name) {
        if (((Map)this.source).containsKey(name)) {
            return name;
        }
        String noDotName = name.replace('.', '_');
        if (!name.equals(noDotName) && ((Map)this.source).containsKey(noDotName)) {
            return noDotName;
        }
        String noHyphenName = name.replace('-', '_');
        if (!name.equals(noHyphenName) && ((Map)this.source).containsKey(noHyphenName)) {
            return noHyphenName;
        }
        String noDotNoHyphenName = noDotName.replace('-', '_');
        if (!noDotName.equals(noDotNoHyphenName) && ((Map)this.source).containsKey(noDotNoHyphenName)) {
            return noDotNoHyphenName;
        }
        return null;
    }
}

