/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.env;

import cn.taketoday.lang.Nullable;
import cn.taketoday.util.StringUtils;

public interface PropertyResolver {
    public boolean containsProperty(String var1);

    @Nullable
    public String getProperty(String var1);

    public String getProperty(String var1, String var2);

    @Nullable
    public <T> T getProperty(String var1, Class<T> var2);

    public <T> T getProperty(String var1, Class<T> var2, T var3);

    public String getRequiredProperty(String var1) throws IllegalStateException;

    public <T> T getRequiredProperty(String var1, Class<T> var2) throws IllegalStateException;

    default public boolean getFlag(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    default public boolean getFlag(String key, boolean defaultFlag) {
        String property = this.getProperty(key);
        return StringUtils.isEmpty(property) ? defaultFlag : Boolean.parseBoolean(property);
    }

    public String resolvePlaceholders(String var1);

    public String resolveRequiredPlaceholders(String var1) throws IllegalArgumentException;
}

