/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.conversion.ConverterFactory;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.StringUtils;

final class StringToEnumConverterFactory
implements ConverterFactory<String, Enum> {
    StringToEnumConverterFactory() {
    }

    @Override
    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToEnum(ClassUtils.getEnumType(targetType));
    }

    private record StringToEnum<T extends Enum>(Class<T> enumType) implements Converter<String, T>
    {
        @Override
        @Nullable
        public T convert(String source) {
            if (StringUtils.isEmpty(source)) {
                return null;
            }
            return Enum.valueOf(this.enumType, source.trim());
        }
    }
}

