/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConditionalGenericConverter;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.core.conversion.support.ObjectToObjectConverter;
import cn.taketoday.lang.Nullable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;

final class FallbackObjectToStringConverter
implements ConditionalGenericConverter {
    FallbackObjectToStringConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class<?> sourceClass = sourceType.getObjectType();
        if (String.class == sourceClass) {
            return false;
        }
        return CharSequence.class.isAssignableFrom(sourceClass) || StringWriter.class.isAssignableFrom(sourceClass) || ObjectToObjectConverter.hasConversionMethodOrConstructor(sourceClass, String.class);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return source != null ? source.toString() : null;
    }
}

