/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.beans.PropertyEditorSupport;

public class ConvertingPropertyEditorAdapter
extends PropertyEditorSupport {
    private final ConversionService conversionService;
    private final TypeDescriptor targetDescriptor;
    private final boolean canConvertToString;

    public ConvertingPropertyEditorAdapter(ConversionService conversionService, TypeDescriptor targetDescriptor) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        Assert.notNull((Object)targetDescriptor, "TypeDescriptor must not be null");
        this.targetDescriptor = targetDescriptor;
        this.conversionService = conversionService;
        this.canConvertToString = conversionService.canConvert(targetDescriptor, TypeDescriptor.valueOf(String.class));
    }

    @Override
    public void setAsText(@Nullable String text) throws IllegalArgumentException {
        this.setValue(this.conversionService.convert(text, TypeDescriptor.valueOf(String.class), this.targetDescriptor));
    }

    @Override
    @Nullable
    public String getAsText() {
        if (this.canConvertToString) {
            return (String)this.conversionService.convert(this.getValue(), this.targetDescriptor, TypeDescriptor.valueOf(String.class));
        }
        return null;
    }
}

