/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.conversion;

import cn.taketoday.core.conversion.Converter;
import cn.taketoday.core.conversion.ConverterFactory;
import cn.taketoday.core.conversion.GenericConverter;
import cn.taketoday.lang.Nullable;
import java.util.Set;

public interface ConverterRegistry {
    public void addConverter(Converter<?, ?> var1);

    public <S, T> void addConverter(Class<S> var1, Class<T> var2, Converter<? super S, ? extends T> var3);

    public void addConverter(GenericConverter var1);

    public void addConverterFactory(ConverterFactory<?, ?> var1);

    public void removeConvertible(Class<?> var1, Class<?> var2);

    public static void registerConverters(@Nullable Set<?> converters, ConverterRegistry registry) {
        if (converters != null) {
            for (Object converter : converters) {
                if (converter instanceof GenericConverter) {
                    GenericConverter genericConverter = (GenericConverter)converter;
                    registry.addConverter(genericConverter);
                    continue;
                }
                if (converter instanceof Converter) {
                    Converter c = (Converter)converter;
                    registry.addConverter(c);
                    continue;
                }
                if (converter instanceof ConverterFactory) {
                    ConverterFactory cf = (ConverterFactory)converter;
                    registry.addConverterFactory(cf);
                    continue;
                }
                throw new IllegalArgumentException("Each converter object must implement one of the Converter, ConverterFactory, or GenericConverter interfaces");
            }
        }
    }
}

