/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.codec;

import cn.taketoday.core.ResolvableType;
import cn.taketoday.core.codec.AbstractEncoder;
import cn.taketoday.core.codec.Hints;
import cn.taketoday.core.io.buffer.DataBuffer;
import cn.taketoday.core.io.buffer.DataBufferFactory;
import cn.taketoday.core.io.buffer.Netty5DataBufferFactory;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.MimeType;
import cn.taketoday.util.MimeTypeUtils;
import io.netty5.buffer.api.Buffer;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class Netty5BufferEncoder
extends AbstractEncoder<Buffer> {
    public Netty5BufferEncoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canEncode(ResolvableType type, @Nullable MimeType mimeType) {
        Class<?> clazz = type.toClass();
        return super.canEncode(type, mimeType) && Buffer.class.isAssignableFrom(clazz);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends Buffer> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(inputStream).map(byteBuffer -> this.encodeValue((Buffer)byteBuffer, bufferFactory, elementType, mimeType, hints));
    }

    @Override
    public DataBuffer encodeValue(Buffer buffer, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(hints)) {
            String logPrefix = Hints.getLogPrefix(hints);
            this.logger.debug(logPrefix + "Writing " + buffer.readableBytes() + " bytes");
        }
        if (bufferFactory instanceof Netty5DataBufferFactory) {
            Netty5DataBufferFactory netty5DataBufferFactory = (Netty5DataBufferFactory)bufferFactory;
            return netty5DataBufferFactory.wrap(buffer);
        }
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes, 0, bytes.length);
        buffer.close();
        return bufferFactory.wrap(bytes);
    }
}

