/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.core.annotation.AbstractMergedAnnotation;
import cn.taketoday.core.annotation.AnnotationConfigurationException;
import cn.taketoday.core.annotation.AttributeMethods;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;

final class SynthesizedMergedAnnotationInvocationHandler<A extends Annotation>
implements InvocationHandler {
    private final Class<A> type;
    private final AttributeMethods attributeMethods;
    private final AbstractMergedAnnotation<?> annotation;
    private final HashMap<String, Object> valueCache = new HashMap(8);
    @Nullable
    private volatile Integer hash;

    SynthesizedMergedAnnotationInvocationHandler(AbstractMergedAnnotation<A> annotation, Class<A> type) {
        this.type = type;
        this.annotation = annotation;
        this.attributeMethods = AttributeMethods.forAnnotationType(type);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String attribute = method.getName();
        int parameterCount = method.getParameterCount();
        if (parameterCount == 1 && attribute.equals("equals") && method.getParameterTypes()[0] == Object.class) {
            return this.annotationEquals(proxy, args[0]);
        }
        if (parameterCount == 0) {
            return switch (attribute) {
                case "toString" -> this.annotationToString();
                case "hashCode" -> this.annotationHashCode();
                case "annotationType" -> this.type;
                default -> this.getAttributeValue(method, true);
            };
        }
        throw new AnnotationConfigurationException(String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method, this.type));
    }

    private boolean annotationEquals(Object proxy, Object other) {
        if (proxy != other) {
            if (!this.type.isInstance(other)) {
                return false;
            }
            for (Method attribute : this.attributeMethods.attributes) {
                Object otherValue;
                Object thisValue = this.getAttributeValue(attribute, false);
                if (ObjectUtils.nullSafeEquals(thisValue, otherValue = ReflectionUtils.invokeMethod(attribute, other))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int annotationHashCode() {
        Integer hash = this.hash;
        if (hash == null) {
            SynthesizedMergedAnnotationInvocationHandler synthesizedMergedAnnotationInvocationHandler = this;
            synchronized (synthesizedMergedAnnotationInvocationHandler) {
                hash = this.hash;
                if (hash == null) {
                    this.hash = hash = this.computeHashCode();
                }
            }
        }
        return hash;
    }

    private Integer computeHashCode() {
        int hashCode = 0;
        for (Method attribute : this.attributeMethods.attributes) {
            Object value = this.getAttributeValue(attribute, false);
            hashCode += 127 * attribute.getName().hashCode() ^ this.getValueHashCode(value);
        }
        return hashCode;
    }

    private int getValueHashCode(Object value) {
        if (value instanceof boolean[]) {
            return Arrays.hashCode((boolean[])value);
        }
        if (value instanceof byte[]) {
            return Arrays.hashCode((byte[])value);
        }
        if (value instanceof char[]) {
            return Arrays.hashCode((char[])value);
        }
        if (value instanceof double[]) {
            return Arrays.hashCode((double[])value);
        }
        if (value instanceof float[]) {
            return Arrays.hashCode((float[])value);
        }
        if (value instanceof int[]) {
            return Arrays.hashCode((int[])value);
        }
        if (value instanceof long[]) {
            return Arrays.hashCode((long[])value);
        }
        if (value instanceof short[]) {
            return Arrays.hashCode((short[])value);
        }
        if (value instanceof Object[]) {
            return Arrays.hashCode((Object[])value);
        }
        return value.hashCode();
    }

    private String annotationToString() {
        StringBuilder builder = new StringBuilder("@").append(this.type.getName()).append('(');
        Method[] attributes = this.attributeMethods.attributes;
        for (int i = 0; i < attributes.length; ++i) {
            Method attribute = attributes[i];
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(attribute.getName());
            builder.append('=');
            builder.append(this.toString(this.getAttributeValue(attribute, false)));
        }
        builder.append(')');
        return builder.toString();
    }

    private String toString(Object value) {
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value.getClass().isArray()) {
            StringBuilder builder = new StringBuilder("[");
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.toString(Array.get(value, i)));
            }
            builder.append(']');
            return builder.toString();
        }
        return String.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttributeValue(Method method, boolean cloneArray) {
        Object value = this.valueCache.get(method.getName());
        if (value == null) {
            HashMap<String, Object> hashMap = this.valueCache;
            synchronized (hashMap) {
                value = this.valueCache.get(method.getName());
                if (value == null) {
                    Class<?> type = ClassUtils.resolvePrimitiveIfNecessary(method.getReturnType());
                    value = this.annotation.getAttributeValue(method.getName(), type);
                    if (value == null) {
                        throw new NoSuchElementException("No value found for attribute named '" + method.getName() + "' in merged annotation " + this.annotation.getType().getName());
                    }
                    this.valueCache.put(method.getName(), value);
                }
            }
        }
        if (cloneArray && value.getClass().isArray() && Array.getLength(value) > 0) {
            value = SynthesizedMergedAnnotationInvocationHandler.cloneArray(value);
        }
        return value;
    }

    private static Object cloneArray(Object array) {
        if (array instanceof boolean[]) {
            return ((boolean[])array).clone();
        }
        if (array instanceof byte[]) {
            return ((byte[])array).clone();
        }
        if (array instanceof char[]) {
            return ((char[])array).clone();
        }
        if (array instanceof double[]) {
            return ((double[])array).clone();
        }
        if (array instanceof float[]) {
            return ((float[])array).clone();
        }
        if (array instanceof int[]) {
            return ((int[])array).clone();
        }
        if (array instanceof long[]) {
            return ((long[])array).clone();
        }
        if (array instanceof short[]) {
            return ((short[])array).clone();
        }
        return ((Object[])array).clone();
    }

    static <A extends Annotation> A createProxy(AbstractMergedAnnotation<A> annotation, Class<A> type) {
        ClassLoader classLoader = type.getClassLoader();
        SynthesizedMergedAnnotationInvocationHandler<A> handler = new SynthesizedMergedAnnotationInvocationHandler<A>(annotation, type);
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, new Class[]{type}, handler));
    }
}

