/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.core.annotation.AnnotationAttributes;
import cn.taketoday.core.annotation.MissingMergedAnnotation;
import cn.taketoday.core.annotation.TypeMappedAnnotation;
import cn.taketoday.lang.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public interface MergedAnnotation<A extends Annotation> {
    public static final String VALUE = "value";

    public Class<A> getType();

    public boolean isPresent();

    public boolean isDirectlyPresent();

    public boolean isMetaPresent();

    public int getDistance();

    public int getAggregateIndex();

    @Nullable
    public Object getSource();

    @Nullable
    public MergedAnnotation<?> getMetaSource();

    public MergedAnnotation<?> getRoot();

    public List<Class<? extends Annotation>> getMetaTypes();

    public boolean hasNonDefaultValue(String var1);

    public boolean hasDefaultValue(String var1) throws NoSuchElementException;

    public byte getByte(String var1) throws NoSuchElementException;

    public byte[] getByteArray(String var1) throws NoSuchElementException;

    public boolean getBoolean(String var1) throws NoSuchElementException;

    default public boolean getBooleanValue() throws NoSuchElementException {
        return this.getBoolean(VALUE);
    }

    public boolean[] getBooleanArray(String var1) throws NoSuchElementException;

    public char getChar(String var1) throws NoSuchElementException;

    public char[] getCharArray(String var1) throws NoSuchElementException;

    public short getShort(String var1) throws NoSuchElementException;

    public short[] getShortArray(String var1) throws NoSuchElementException;

    public int getInt(String var1) throws NoSuchElementException;

    default public int getIntValue() throws NoSuchElementException {
        return this.getInt(VALUE);
    }

    public int[] getIntArray(String var1) throws NoSuchElementException;

    public long getLong(String var1) throws NoSuchElementException;

    default public long getLongValue() throws NoSuchElementException {
        return this.getLong(VALUE);
    }

    public long[] getLongArray(String var1) throws NoSuchElementException;

    public double getDouble(String var1) throws NoSuchElementException;

    default public double getDoubleValue() throws NoSuchElementException {
        return this.getDouble(VALUE);
    }

    public double[] getDoubleArray(String var1) throws NoSuchElementException;

    public float getFloat(String var1) throws NoSuchElementException;

    public float[] getFloatArray(String var1) throws NoSuchElementException;

    public String getString(String var1) throws NoSuchElementException;

    default public String getStringValue() throws NoSuchElementException {
        return this.getString(VALUE);
    }

    public String[] getStringArray(String var1) throws NoSuchElementException;

    default public String[] getStringValueArray() throws NoSuchElementException {
        return this.getStringArray(VALUE);
    }

    public <T> Class<T> getClass(String var1) throws NoSuchElementException;

    default public <T> Class<T> getClassValue() throws NoSuchElementException {
        return this.getClass(VALUE);
    }

    public <T> Class<T>[] getClassArray(String var1) throws NoSuchElementException;

    default public <T> Class<T>[] getClassValueArray() throws NoSuchElementException {
        return this.getClassArray(VALUE);
    }

    public <E extends Enum<E>> E getEnum(String var1, Class<E> var2) throws NoSuchElementException;

    public <E extends Enum<E>> E[] getEnumArray(String var1, Class<E> var2) throws NoSuchElementException;

    public <T extends Annotation> MergedAnnotation<T> getAnnotation(String var1, Class<T> var2) throws NoSuchElementException;

    public <T extends Annotation> MergedAnnotation<T>[] getAnnotationArray(String var1, Class<T> var2) throws NoSuchElementException;

    public Optional<Object> getValue(String var1);

    default public <T> Optional<T> getValue(Class<T> type) {
        return this.getValue(VALUE, type);
    }

    public <T> Optional<T> getValue(String var1, Class<T> var2);

    public Optional<Object> getDefaultValue(String var1);

    public <T> Optional<T> getDefaultValue(String var1, Class<T> var2);

    public MergedAnnotation<A> filterDefaultValues();

    public MergedAnnotation<A> filterAttributes(Predicate<String> var1);

    public MergedAnnotation<A> withNonMergedAttributes();

    public AnnotationAttributes asAnnotationAttributes(Adapt ... var1);

    public Map<String, Object> asMap(Adapt ... var1);

    public <T extends Map<String, Object>> T asMap(Function<MergedAnnotation<?>, T> var1, Adapt ... var2);

    public boolean isSynthesizable();

    public A synthesize() throws NoSuchElementException;

    public Optional<A> synthesize(Predicate<? super MergedAnnotation<A>> var1) throws NoSuchElementException;

    public static <A extends Annotation> MergedAnnotation<A> missing() {
        return MissingMergedAnnotation.getInstance();
    }

    public static <A extends Annotation> MergedAnnotation<A> from(A annotation) {
        return MergedAnnotation.from(null, annotation);
    }

    public static <A extends Annotation> MergedAnnotation<A> from(@Nullable Object source, A annotation) {
        return TypeMappedAnnotation.from(source, annotation);
    }

    public static <A extends Annotation> MergedAnnotation<A> valueOf(Class<A> annotationType) {
        return MergedAnnotation.valueOf(null, annotationType, null);
    }

    public static <A extends Annotation> MergedAnnotation<A> valueOf(Class<A> annotationType, @Nullable Map<String, ?> attributes) {
        return MergedAnnotation.valueOf(null, annotationType, attributes);
    }

    public static <A extends Annotation> MergedAnnotation<A> valueOf(@Nullable AnnotatedElement source, Class<A> annotationType, @Nullable Map<String, ?> attributes) {
        return MergedAnnotation.valueOf(null, source, annotationType, attributes);
    }

    public static <A extends Annotation> MergedAnnotation<A> valueOf(@Nullable ClassLoader classLoader, @Nullable Object source, Class<A> annotationType, @Nullable Map<String, ?> attributes) {
        return TypeMappedAnnotation.of(classLoader, source, annotationType, attributes);
    }

    public static enum Adapt {
        CLASS_TO_STRING,
        ANNOTATION_TO_MAP;

        static final Adapt[] EMPTY;

        final boolean containsIn(Adapt ... adaptations) {
            for (Adapt candidate : adaptations) {
                if (candidate != this) continue;
                return true;
            }
            return false;
        }

        public static Adapt[] values(boolean classToString, boolean annotationsToMap) {
            int size = 0;
            if (classToString) {
                ++size;
            }
            if (annotationsToMap) {
                ++size;
            }
            if (size == 0) {
                return EMPTY;
            }
            Adapt[] adapts = new Adapt[size];
            if (classToString) {
                adapts[--size] = CLASS_TO_STRING;
            }
            if (annotationsToMap) {
                adapts[--size] = ANNOTATION_TO_MAP;
            }
            return adapts;
        }

        static {
            EMPTY = new Adapt[0];
        }
    }
}

