/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.annotation;

import cn.taketoday.core.DecoratingProxy;
import cn.taketoday.core.OrderComparator;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.annotation.OrderUtils;
import cn.taketoday.lang.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;

public class AnnotationAwareOrderComparator
extends OrderComparator {
    public static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

    @Override
    @Nullable
    protected Integer findOrder(Object obj) {
        Integer order = super.findOrder(obj);
        if (order != null) {
            return order;
        }
        return this.findOrderFromAnnotation(obj);
    }

    @Nullable
    private Integer findOrderFromAnnotation(Object obj) {
        MergedAnnotations annotations;
        Class<?> element = obj instanceof AnnotatedElement ? (Class<?>)obj : obj.getClass();
        Integer order = OrderUtils.getOrderFromAnnotations(element, annotations = MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY));
        if (order == null && obj instanceof DecoratingProxy) {
            return this.findOrderFromAnnotation(((DecoratingProxy)obj).getDecoratedClass());
        }
        return order;
    }

    @Override
    @Nullable
    public Integer getPriority(Object obj) {
        if (obj instanceof Class) {
            return OrderUtils.getPriority((Class)obj);
        }
        Integer priority = OrderUtils.getPriority(obj.getClass());
        if (priority == null && obj instanceof DecoratingProxy) {
            return this.getPriority(((DecoratingProxy)obj).getDecoratedClass());
        }
        return priority;
    }

    public static void sort(List<?> list) {
        if (list.size() > 1) {
            list.sort(INSTANCE);
        }
    }

    public static void sort(Object[] array) {
        if (array.length > 1) {
            Arrays.sort(array, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value) {
        if (value instanceof Object[]) {
            AnnotationAwareOrderComparator.sort((Object[])value);
        } else if (value instanceof List) {
            AnnotationAwareOrderComparator.sort((List)value);
        }
    }
}

