/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.ResolvableType;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GenericTypeResolver {
    private static final ConcurrentHashMap<Class<?>, Map<TypeVariable, Type>> typeVariableCache = new ConcurrentHashMap();

    public static Class<?> resolveReturnType(Method method, Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return ResolvableType.forReturnType(method, clazz).resolve(method.getReturnType());
    }

    public static Class<?> resolveReturnTypeArgument(Method method, Class<?> genericIfc) {
        Assert.notNull((Object)method, "Method must not be null");
        ResolvableType resolvableType = ResolvableType.forReturnType(method).as(genericIfc);
        if (!resolvableType.hasGenerics() || resolvableType.getType() instanceof WildcardType) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    @Nullable
    public static <T> Class<T> resolveTypeArgument(Class<?> clazz, Class<?> genericIfc) {
        ResolvableType resolvableType = ResolvableType.fromClass(clazz).as(genericIfc);
        if (!resolvableType.hasGenerics()) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    private static <T> Class<T> getSingleGeneric(ResolvableType resolvableType) {
        Assert.isTrue(resolvableType.getGenerics().length == 1, () -> "Expected 1 type argument on generic interface [" + resolvableType + "] but found " + resolvableType.getGenerics().length);
        return resolvableType.getGeneric(new int[0]).resolve();
    }

    @Nullable
    public static Class<?>[] resolveTypeArguments(Class<?> clazz, Class<?> genericIfc) {
        ResolvableType type = ResolvableType.fromClass(clazz).as(genericIfc);
        if (!type.hasGenerics() || type.isEntirelyUnresolvable()) {
            return null;
        }
        return type.resolveGenerics(Object.class);
    }

    public static Type resolveType(Type genericType, Class<?> contextClass) {
        if (contextClass != null) {
            ResolvableType resolvedType;
            if (genericType instanceof TypeVariable) {
                Class<?> resolved;
                ResolvableType resolvedTypeVariable = GenericTypeResolver.resolveVariable((TypeVariable)genericType, ResolvableType.fromClass(contextClass));
                if (resolvedTypeVariable != ResolvableType.NONE && (resolved = resolvedTypeVariable.resolve()) != null) {
                    return resolved;
                }
            } else if (genericType instanceof ParameterizedType && (resolvedType = ResolvableType.fromType(genericType)).hasUnresolvableGenerics()) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                ResolvableType contextType = ResolvableType.fromClass(contextClass);
                for (int i = 0; i < typeArguments.length; ++i) {
                    Type typeArgument = typeArguments[i];
                    if (typeArgument instanceof TypeVariable) {
                        ResolvableType resolvedTypeArgument = GenericTypeResolver.resolveVariable((TypeVariable)typeArgument, contextType);
                        if (resolvedTypeArgument != ResolvableType.NONE) {
                            generics[i] = resolvedTypeArgument.resolve();
                            continue;
                        }
                        generics[i] = ResolvableType.fromType(typeArgument).resolve();
                        continue;
                    }
                    generics[i] = ResolvableType.fromType(typeArgument).resolve();
                }
                Class<?> rawClass = resolvedType.getRawClass();
                if (rawClass != null) {
                    return ResolvableType.fromClassWithGenerics(rawClass, generics).getType();
                }
            }
        }
        return genericType;
    }

    private static ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
        ResolvableType superType;
        ResolvableType resolvedType;
        if (contextType.hasGenerics()) {
            ResolvableType.VariableResolver variableResolver = contextType.asVariableResolver();
            if (variableResolver == null) {
                return ResolvableType.NONE;
            }
            resolvedType = variableResolver.resolveVariable(typeVariable);
            if (resolvedType != null) {
                return resolvedType;
            }
        }
        if ((superType = contextType.getSuperType()) != ResolvableType.NONE && (resolvedType = GenericTypeResolver.resolveVariable(typeVariable, superType)) != ResolvableType.NONE) {
            return resolvedType;
        }
        for (ResolvableType ifc : contextType.getInterfaces()) {
            resolvedType = GenericTypeResolver.resolveVariable(typeVariable, ifc);
            if (resolvedType == ResolvableType.NONE) continue;
            return resolvedType;
        }
        return ResolvableType.NONE;
    }

    public static Class<?> resolveType(Type genericType, Map<TypeVariable, Type> map) {
        return ResolvableType.valueOf(genericType, new TypeVariableMapVariableResolver(map)).toClass();
    }

    public static Map<TypeVariable, Type> getTypeVariableMap(Class<?> clazz) {
        Map<TypeVariable, Type> typeVariableMap = typeVariableCache.get(clazz);
        if (typeVariableMap == null) {
            typeVariableMap = new HashMap<TypeVariable, Type>();
            GenericTypeResolver.buildTypeVariableMap(ResolvableType.fromClass(clazz), typeVariableMap);
            typeVariableCache.put(clazz, Collections.unmodifiableMap(typeVariableMap));
        }
        return typeVariableMap;
    }

    private static void buildTypeVariableMap(ResolvableType type, Map<TypeVariable, Type> typeVariableMap) {
        if (type != ResolvableType.NONE) {
            Class<?> resolved = type.resolve();
            if (resolved != null && type.getType() instanceof ParameterizedType) {
                TypeVariable<Class<?>>[] variables = resolved.getTypeParameters();
                for (int i = 0; i < variables.length; ++i) {
                    ResolvableType generic = type.getGeneric(i);
                    while (generic.getType() instanceof TypeVariable) {
                        generic = generic.resolveType();
                    }
                    if (generic == ResolvableType.NONE) continue;
                    typeVariableMap.put(variables[i], generic.getType());
                }
            }
            GenericTypeResolver.buildTypeVariableMap(type.getSuperType(), typeVariableMap);
            for (ResolvableType interfaceType : type.getInterfaces()) {
                GenericTypeResolver.buildTypeVariableMap(interfaceType, typeVariableMap);
            }
            if (resolved != null && resolved.isMemberClass()) {
                GenericTypeResolver.buildTypeVariableMap(ResolvableType.fromClass(resolved.getEnclosingClass()), typeVariableMap);
            }
        }
    }

    private record TypeVariableMapVariableResolver(Map<TypeVariable, Type> typeVariableMap) implements ResolvableType.VariableResolver
    {
        @Override
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            Type type = this.typeVariableMap.get(variable);
            return type != null ? ResolvableType.fromType(type) : null;
        }

        @Override
        public Object getSource() {
            return this.typeVariableMap;
        }
    }
}

