/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.ArraySizeTrimmer;
import cn.taketoday.core.MultiValueMap;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class DefaultMultiValueMap<K, V>
implements MultiValueMap<K, V>,
Serializable,
Cloneable,
ArraySizeTrimmer {
    private static final long serialVersionUID = 1L;
    public static final Function defaultMappingFunction = k -> new ArrayList(1);
    private final Map<K, List<V>> map;
    private final transient Function<K, List<V>> mappingFunction;

    public DefaultMultiValueMap() {
        this(new HashMap());
    }

    public DefaultMultiValueMap(Function<K, List<V>> mappingFunction) {
        this.map = new HashMap<K, List<V>>();
        this.mappingFunction = mappingFunction;
    }

    public DefaultMultiValueMap(int initialCapacity) {
        this(new HashMap(initialCapacity));
    }

    public DefaultMultiValueMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, defaultMappingFunction);
    }

    public DefaultMultiValueMap(int initialCapacity, float loadFactor, Function<K, List<V>> mappingFunction) {
        this.map = new HashMap<K, List<V>>(initialCapacity, loadFactor);
        this.mappingFunction = mappingFunction;
    }

    public DefaultMultiValueMap(Map<K, List<V>> map) {
        this.map = map;
        this.mappingFunction = defaultMappingFunction;
    }

    public DefaultMultiValueMap(Map<K, List<V>> map, Function<K, List<V>> mappingFunction) {
        this.map = map;
        this.mappingFunction = mappingFunction;
    }

    public DefaultMultiValueMap(Map<K, List<V>> map, Function<K, List<V>> mappingFunction, boolean copy) {
        this.map = copy ? new HashMap(map) : map;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public V getFirst(K key) {
        List<V> values = this.map.get(key);
        return values != null && !values.isEmpty() ? (V)values.get(0) : null;
    }

    @Override
    public void add(K key, @Nullable V value) {
        List<V> values = this.map.computeIfAbsent(key, this.mappingFunction);
        values.add(value);
    }

    @Override
    public void addAll(K key, @Nullable List<? extends V> values) {
        if (values != null) {
            List<V> currentValues = this.map.computeIfAbsent(key, this.mappingFunction);
            currentValues.addAll(values);
        }
    }

    @Override
    public void addAll(K key, @Nullable Collection<? extends V> values) {
        if (values != null) {
            List<V> currentValues = this.map.computeIfAbsent(key, this.mappingFunction);
            currentValues.addAll(values);
        }
    }

    @Override
    public void addAll(K key, @Nullable Enumeration<? extends V> values) {
        if (values != null) {
            List<V> currentValues = this.map.computeIfAbsent(key, this.mappingFunction);
            CollectionUtils.addAll(currentValues, values);
            CollectionUtils.trimToSize(currentValues);
        }
    }

    @Override
    public void set(K key, @Nullable V value) {
        List<V> values = this.mappingFunction.apply(key);
        values.add(value);
        this.map.put(key, values);
    }

    @Override
    public void trimToSize() {
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            CollectionUtils.trimToSize(entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    @Nullable
    public List<V> get(Object key) {
        return this.map.get(key);
    }

    @Override
    @Nullable
    public List<V> put(K key, List<V> value) {
        return this.map.put(key, value);
    }

    @Override
    @Nullable
    public List<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@NonNull Map<? extends K, ? extends List<V>> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.map.entrySet();
    }

    public DefaultMultiValueMap<K, V> deepCopy() {
        DefaultMultiValueMap<K, V> ret = new DefaultMultiValueMap<K, V>(this.map.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            List<V> value = entry.getValue();
            List<V> apply = this.mappingFunction.apply(key);
            apply.addAll(value);
            ret.put(key, apply);
        }
        return ret;
    }

    public DefaultMultiValueMap<K, V> clone() {
        return this.cloneMap();
    }

    public DefaultMultiValueMap<K, V> cloneMap() {
        return new DefaultMultiValueMap<K, V>(this, this.mappingFunction, true);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

