/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.AliasRegistry;
import cn.taketoday.core.StringValueResolver;
import cn.taketoday.lang.Assert;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultAliasRegistry
implements AliasRegistry {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<String, String> aliasMap = new ConcurrentHashMap(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAlias(String name, String alias) {
        Assert.hasText(name, "'name' must not be empty");
        Assert.hasText(alias, "'alias' must not be empty");
        ConcurrentHashMap<String, String> concurrentHashMap = this.aliasMap;
        synchronized (concurrentHashMap) {
            if (alias.equals(name)) {
                this.aliasMap.remove(alias);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Alias definition '{}' ignored since it points to same name", (Object)alias);
                }
            } else {
                String registeredName = this.aliasMap.get(alias);
                if (registeredName != null) {
                    if (registeredName.equals(name)) {
                        return;
                    }
                    if (!this.allowAliasOverriding()) {
                        throw new IllegalStateException("Cannot define alias '" + alias + "' for name '" + name + "': It is already registered for name '" + registeredName + "'.");
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Overriding alias '{}' definition for registered name '{}' with new target name '{}'", alias, registeredName, name);
                    }
                }
                this.checkForAliasCircle(name, alias);
                this.aliasMap.put(alias, name);
                if (this.log.isDebugEnabled()) {
                    this.log.trace("Alias definition '{}' registered for name '{}'", (Object)alias, (Object)name);
                }
            }
        }
    }

    protected boolean allowAliasOverriding() {
        return true;
    }

    public boolean hasAlias(String name, String alias) {
        String registeredName = this.aliasMap.get(alias);
        return Objects.equals(registeredName, name) || registeredName != null && this.hasAlias(name, registeredName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAlias(String alias) {
        ConcurrentHashMap<String, String> concurrentHashMap = this.aliasMap;
        synchronized (concurrentHashMap) {
            String name = this.aliasMap.remove(alias);
            if (name == null) {
                throw new IllegalStateException("No alias '" + alias + "' registered");
            }
        }
    }

    @Override
    public boolean isAlias(String name) {
        return this.aliasMap.containsKey(name);
    }

    @Override
    public String[] getAliases(String name) {
        return StringUtils.toStringArray(this.getAliasList(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAliasList(String name) {
        ArrayList<String> result = new ArrayList<String>();
        ConcurrentHashMap<String, String> concurrentHashMap = this.aliasMap;
        synchronized (concurrentHashMap) {
            this.retrieveAliases(name, result);
        }
        return result;
    }

    private void retrieveAliases(String name, ArrayList<String> result) {
        for (Map.Entry<String, String> entry : this.aliasMap.entrySet()) {
            String alias = entry.getKey();
            String registeredName = entry.getValue();
            if (!registeredName.equals(name)) continue;
            result.add(alias);
            this.retrieveAliases(alias, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAliases(StringValueResolver valueResolver) {
        Assert.notNull((Object)valueResolver, "StringValueResolver must not be null");
        ConcurrentHashMap<String, String> concurrentHashMap = this.aliasMap;
        synchronized (concurrentHashMap) {
            HashMap<String, String> aliasCopy = new HashMap<String, String>(this.aliasMap);
            for (Map.Entry<String, String> entry : aliasCopy.entrySet()) {
                String alias = entry.getKey();
                String registeredName = entry.getValue();
                String resolvedAlias = valueResolver.resolveStringValue(alias);
                String resolvedName = valueResolver.resolveStringValue(registeredName);
                if (resolvedAlias == null || resolvedName == null || resolvedAlias.equals(resolvedName)) {
                    this.aliasMap.remove(alias);
                    continue;
                }
                if (!resolvedAlias.equals(alias)) {
                    String existingName = this.aliasMap.get(resolvedAlias);
                    if (existingName != null) {
                        if (existingName.equals(resolvedName)) {
                            this.aliasMap.remove(alias);
                            return;
                        }
                        throw new IllegalStateException("Cannot register resolved alias '" + resolvedAlias + "' (original: '" + alias + "') for name '" + resolvedName + "': It is already registered for name '" + registeredName + "'.");
                    }
                    this.checkForAliasCircle(resolvedName, resolvedAlias);
                    this.aliasMap.remove(alias);
                    this.aliasMap.put(resolvedAlias, resolvedName);
                    continue;
                }
                if (registeredName.equals(resolvedName)) continue;
                this.aliasMap.put(alias, resolvedName);
            }
        }
    }

    protected void checkForAliasCircle(String name, String alias) {
        if (this.hasAlias(alias, name)) {
            throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name + "': Circular reference - '" + name + "' is a direct or indirect alias for '" + alias + "' already");
        }
    }

    public String canonicalName(String name) {
        String resolvedName;
        String canonicalName = name;
        do {
            if ((resolvedName = this.aliasMap.get(canonicalName)) == null) continue;
            canonicalName = resolvedName;
        } while (resolvedName != null);
        return canonicalName;
    }
}

