/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.MethodParameter;
import cn.taketoday.core.ReactiveAdapter;
import cn.taketoday.core.ReactiveAdapterRegistry;
import cn.taketoday.core.ResolvableType;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Iterator;

public final class Conventions {
    private static final String PLURAL_SUFFIX = "List";

    private Conventions() {
    }

    public static String getVariableName(Object value) {
        Class<?> valueClass;
        Assert.notNull(value, "Value is required");
        boolean pluralize = false;
        if (value.getClass().isArray()) {
            valueClass = value.getClass().getComponentType();
            pluralize = true;
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            Object valueToCheck = Conventions.peekAhead(collection);
            valueClass = Conventions.getClassForValue(valueToCheck);
            pluralize = true;
        } else {
            valueClass = Conventions.getClassForValue(value);
        }
        String name = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String getVariableNameForParameter(Parameter parameter) {
        Class<?> valueClass;
        Assert.notNull((Object)parameter, "Parameter is required");
        boolean pluralize = false;
        String reactiveSuffix = "";
        if (parameter.getType().isArray()) {
            valueClass = parameter.getType().getComponentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(parameter.getType())) {
            valueClass = ResolvableType.fromParameter(parameter).asCollection().resolveGeneric(new int[0]);
            if (valueClass == null) {
                throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection parameter type");
            }
            pluralize = true;
        } else {
            valueClass = parameter.getType();
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(valueClass);
            if (adapter != null && !adapter.getDescriptor().isNoValue()) {
                reactiveSuffix = ClassUtils.getShortName(valueClass);
                valueClass = ResolvableType.fromParameter(parameter).getGeneric(new int[0]).toClass();
            }
        }
        String name = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name + reactiveSuffix;
    }

    public static String getVariableNameForParameter(MethodParameter parameter) {
        Class<?> valueClass;
        Assert.notNull((Object)parameter, "MethodParameter is required");
        boolean pluralize = false;
        String reactiveSuffix = "";
        if (parameter.getParameterType().isArray()) {
            valueClass = parameter.getParameterType().getComponentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(parameter.getParameterType())) {
            valueClass = ResolvableType.forMethodParameter(parameter).asCollection().resolveGeneric(new int[0]);
            if (valueClass == null) {
                throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection parameter type");
            }
            pluralize = true;
        } else {
            valueClass = parameter.getParameterType();
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(valueClass);
            if (adapter != null && !adapter.getDescriptor().isNoValue()) {
                reactiveSuffix = ClassUtils.getShortName(valueClass);
                valueClass = parameter.nested().getNestedParameterType();
            }
        }
        String name = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name + reactiveSuffix;
    }

    public static String getVariableNameForReturnType(Method method) {
        return Conventions.getVariableNameForReturnType(method, method.getReturnType(), null);
    }

    public static String getVariableNameForReturnType(Method method, @Nullable Object value) {
        return Conventions.getVariableNameForReturnType(method, method.getReturnType(), value);
    }

    public static String getVariableNameForReturnType(Method method, Class<?> resolvedType, @Nullable Object value) {
        Class<?> valueClass;
        Assert.notNull((Object)method, "Method is required");
        if (Object.class == resolvedType) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot generate variable name for an Object return type with null value");
            }
            return Conventions.getVariableName(value);
        }
        boolean pluralize = false;
        String reactiveSuffix = "";
        if (resolvedType.isArray()) {
            valueClass = resolvedType.getComponentType();
            pluralize = true;
        } else if (Collection.class.isAssignableFrom(resolvedType)) {
            valueClass = ResolvableType.forReturnType(method).asCollection().resolveGeneric(new int[0]);
            if (valueClass == null) {
                if (!(value instanceof Collection)) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and a non-Collection value");
                }
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    throw new IllegalArgumentException("Cannot generate variable name for non-typed Collection return type and an empty Collection value");
                }
                Object valueToCheck = Conventions.peekAhead(collection);
                valueClass = Conventions.getClassForValue(valueToCheck);
            }
            pluralize = true;
        } else {
            valueClass = resolvedType;
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(valueClass);
            if (adapter != null && !adapter.getDescriptor().isNoValue()) {
                reactiveSuffix = ClassUtils.getShortName(valueClass);
                valueClass = ResolvableType.forReturnType(method).getGeneric(new int[0]).toClass();
            }
        }
        String name = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name + reactiveSuffix;
    }

    public static String attributeNameToPropertyName(String attributeName) {
        Assert.notNull((Object)attributeName, "'attributeName' is required");
        if (!attributeName.contains("-")) {
            return attributeName;
        }
        char[] result = new char[attributeName.length() - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        for (int i = 0; i < attributeName.length(); ++i) {
            char c = attributeName.charAt(i);
            if (c == '-') {
                upperCaseNext = true;
                continue;
            }
            if (upperCaseNext) {
                result[currPos++] = Character.toUpperCase(c);
                upperCaseNext = false;
                continue;
            }
            result[currPos++] = c;
        }
        return new String(result, 0, currPos);
    }

    public static String getQualifiedAttributeName(Class<?> enclosingClass, String attributeName) {
        Assert.notNull(enclosingClass, "'enclosingClass' is required");
        Assert.notNull((Object)attributeName, "'attributeName' is required");
        return enclosingClass.getName() + "." + attributeName;
    }

    private static Class<?> getClassForValue(Object value) {
        Class<?> valueClass = value.getClass();
        if (Proxy.isProxyClass(valueClass)) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = valueClass.getInterfaces()) {
                if (ClassUtils.isJavaLanguageInterface(ifc)) continue;
                return ifc;
            }
        } else if (valueClass.getName().lastIndexOf(36) != -1 && valueClass.getDeclaringClass() == null) {
            valueClass = valueClass.getSuperclass();
        }
        return valueClass;
    }

    private static String pluralize(String name) {
        return name + PLURAL_SUFFIX;
    }

    private static <E> E peekAhead(Collection<E> collection) {
        Iterator<E> it = collection.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
        }
        E value = it.next();
        if (value == null) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - only null element found");
        }
        return value;
    }
}

