/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree.analysis;

import cn.taketoday.bytecode.ConstantDynamic;
import cn.taketoday.bytecode.Handle;
import cn.taketoday.bytecode.Opcodes;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.tree.AbstractInsnNode;
import cn.taketoday.bytecode.tree.FieldInsnNode;
import cn.taketoday.bytecode.tree.IntInsnNode;
import cn.taketoday.bytecode.tree.InvokeDynamicInsnNode;
import cn.taketoday.bytecode.tree.LdcInsnNode;
import cn.taketoday.bytecode.tree.MethodInsnNode;
import cn.taketoday.bytecode.tree.MultiANewArrayInsnNode;
import cn.taketoday.bytecode.tree.TypeInsnNode;
import cn.taketoday.bytecode.tree.analysis.AnalyzerException;
import cn.taketoday.bytecode.tree.analysis.BasicValue;
import cn.taketoday.bytecode.tree.analysis.Interpreter;
import java.util.List;

public class BasicInterpreter
extends Interpreter<BasicValue>
implements Opcodes {
    public static final Type NULL_TYPE = Type.fromInternalName("null");

    @Override
    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return switch (type.getSort()) {
            case 0 -> null;
            case 7 -> BasicValue.LONG_VALUE;
            case 6 -> BasicValue.FLOAT_VALUE;
            case 8 -> BasicValue.DOUBLE_VALUE;
            case 9, 10 -> BasicValue.REFERENCE_VALUE;
            case 1, 2, 3, 4, 5 -> BasicValue.INT_VALUE;
            default -> throw new AssertionError();
        };
    }

    @Override
    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 1: {
                return this.newValue(NULL_TYPE);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return BasicValue.INT_VALUE;
            }
            case 9: 
            case 10: {
                return BasicValue.LONG_VALUE;
            }
            case 11: 
            case 12: 
            case 13: {
                return BasicValue.FLOAT_VALUE;
            }
            case 14: 
            case 15: {
                return BasicValue.DOUBLE_VALUE;
            }
            case 18: {
                Object value = ((LdcInsnNode)insn).cst;
                if (value instanceof Integer) {
                    return BasicValue.INT_VALUE;
                }
                if (value instanceof Float) {
                    return BasicValue.FLOAT_VALUE;
                }
                if (value instanceof Long) {
                    return BasicValue.LONG_VALUE;
                }
                if (value instanceof Double) {
                    return BasicValue.DOUBLE_VALUE;
                }
                if (value instanceof String) {
                    return this.newValue(Type.fromInternalName("java/lang/String"));
                }
                if (value instanceof Type) {
                    int sort = ((Type)value).getSort();
                    if (sort == 10 || sort == 9) {
                        return this.newValue(Type.fromInternalName("java/lang/Class"));
                    }
                    if (sort == 11) {
                        return this.newValue(Type.fromInternalName("java/lang/invoke/MethodType"));
                    }
                    throw new AnalyzerException(insn, "Illegal LDC value " + value);
                }
                if (value instanceof Handle) {
                    return this.newValue(Type.fromInternalName("java/lang/invoke/MethodHandle"));
                }
                if (value instanceof ConstantDynamic) {
                    return this.newValue(Type.fromDescriptor(((ConstantDynamic)value).getDescriptor()));
                }
                throw new AnalyzerException(insn, "Illegal LDC value " + value);
            }
            case 168: {
                return BasicValue.RETURNADDRESS_VALUE;
            }
            case 178: {
                return this.newValue(Type.fromDescriptor(((FieldInsnNode)insn).desc));
            }
            case 187: {
                return this.newValue(Type.fromInternalName(((TypeInsnNode)insn).desc));
            }
        }
        throw new AssertionError();
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        return value;
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: 
            case 190: 
            case 193: {
                return BasicValue.INT_VALUE;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return BasicValue.FLOAT_VALUE;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return BasicValue.LONG_VALUE;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return BasicValue.DOUBLE_VALUE;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
            case 180: {
                return this.newValue(Type.fromDescriptor(((FieldInsnNode)insn).desc));
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        return this.newValue(Type.fromDescriptor("[Z"));
                    }
                    case 5: {
                        return this.newValue(Type.fromDescriptor("[C"));
                    }
                    case 8: {
                        return this.newValue(Type.fromDescriptor("[B"));
                    }
                    case 9: {
                        return this.newValue(Type.fromDescriptor("[S"));
                    }
                    case 10: {
                        return this.newValue(Type.fromDescriptor("[I"));
                    }
                    case 6: {
                        return this.newValue(Type.fromDescriptor("[F"));
                    }
                    case 7: {
                        return this.newValue(Type.fromDescriptor("[D"));
                    }
                    case 11: {
                        return this.newValue(Type.fromDescriptor("[J"));
                    }
                }
                throw new AnalyzerException(insn, "Invalid array type");
            }
            case 189: {
                return this.newValue(Type.fromDescriptor("[" + Type.fromInternalName(((TypeInsnNode)insn).desc)));
            }
            case 192: {
                return this.newValue(Type.fromInternalName(((TypeInsnNode)insn).desc));
            }
        }
        throw new AssertionError();
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        return switch (insn.getOpcode()) {
            case 46, 51, 52, 53, 96, 100, 104, 108, 112, 120, 122, 124, 126, 128, 130, 148, 149, 150, 151, 152 -> BasicValue.INT_VALUE;
            case 48, 98, 102, 106, 110, 114 -> BasicValue.FLOAT_VALUE;
            case 47, 97, 101, 105, 109, 113, 121, 123, 125, 127, 129, 131 -> BasicValue.LONG_VALUE;
            case 49, 99, 103, 107, 111, 115 -> BasicValue.DOUBLE_VALUE;
            case 50 -> BasicValue.REFERENCE_VALUE;
            case 159, 160, 161, 162, 163, 164, 165, 166, 181 -> null;
            default -> throw new AssertionError();
        };
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        return null;
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            return this.newValue(Type.fromDescriptor(((MultiANewArrayInsnNode)insn).desc));
        }
        if (opcode == 186) {
            return this.newValue(Type.forReturnType(((InvokeDynamicInsnNode)insn).desc));
        }
        return this.newValue(Type.forReturnType(((MethodInsnNode)insn).desc));
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, BasicValue value, BasicValue expected) throws AnalyzerException {
    }

    @Override
    public BasicValue merge(BasicValue value1, BasicValue value2) {
        if (!value1.equals(value2)) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return value1;
    }
}

