/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.ModuleVisitor;
import cn.taketoday.bytecode.tree.ModuleExportNode;
import cn.taketoday.bytecode.tree.ModuleOpenNode;
import cn.taketoday.bytecode.tree.ModuleProvideNode;
import cn.taketoday.bytecode.tree.ModuleRequireNode;
import cn.taketoday.bytecode.tree.Util;
import java.util.ArrayList;
import java.util.List;

public class ModuleNode
extends ModuleVisitor {
    public String name;
    public int access;
    public String version;
    public String mainClass;
    public List<String> packages;
    public List<ModuleRequireNode> requires;
    public List<ModuleExportNode> exports;
    public List<ModuleOpenNode> opens;
    public List<String> uses;
    public List<ModuleProvideNode> provides;

    public ModuleNode(String name, int access, String version) {
        this.name = name;
        this.access = access;
        this.version = version;
    }

    public ModuleNode(String name, int access, String version, List<ModuleRequireNode> requires, List<ModuleExportNode> exports, List<ModuleOpenNode> opens, List<String> uses, List<ModuleProvideNode> provides) {
        this.name = name;
        this.access = access;
        this.version = version;
        this.requires = requires;
        this.exports = exports;
        this.opens = opens;
        this.uses = uses;
        this.provides = provides;
    }

    @Override
    public void visitMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public void visitPackage(String packaze) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>(5);
        }
        this.packages.add(packaze);
    }

    @Override
    public void visitRequire(String module, int access, String version) {
        if (this.requires == null) {
            this.requires = new ArrayList<ModuleRequireNode>(5);
        }
        this.requires.add(new ModuleRequireNode(module, access, version));
    }

    @Override
    public void visitExport(String packaze, int access, String ... modules) {
        if (this.exports == null) {
            this.exports = new ArrayList<ModuleExportNode>(5);
        }
        this.exports.add(new ModuleExportNode(packaze, access, Util.asArrayList(modules)));
    }

    @Override
    public void visitOpen(String packaze, int access, String ... modules) {
        if (this.opens == null) {
            this.opens = new ArrayList<ModuleOpenNode>(5);
        }
        this.opens.add(new ModuleOpenNode(packaze, access, Util.asArrayList(modules)));
    }

    @Override
    public void visitUse(String service) {
        if (this.uses == null) {
            this.uses = new ArrayList<String>(5);
        }
        this.uses.add(service);
    }

    @Override
    public void visitProvide(String service, String ... providers) {
        if (this.provides == null) {
            this.provides = new ArrayList<ModuleProvideNode>(5);
        }
        this.provides.add(new ModuleProvideNode(service, Util.asArrayList(providers)));
    }

    @Override
    public void visitEnd() {
    }

    public void accept(ClassVisitor classVisitor) {
        ModuleVisitor moduleVisitor = classVisitor.visitModule(this.name, this.access, this.version);
        if (moduleVisitor == null) {
            return;
        }
        if (this.mainClass != null) {
            moduleVisitor.visitMainClass(this.mainClass);
        }
        if (this.packages != null) {
            for (String aPackage : this.packages) {
                moduleVisitor.visitPackage(aPackage);
            }
        }
        if (this.requires != null) {
            for (ModuleRequireNode require : this.requires) {
                require.accept(moduleVisitor);
            }
        }
        if (this.exports != null) {
            for (ModuleExportNode export : this.exports) {
                export.accept(moduleVisitor);
            }
        }
        if (this.opens != null) {
            for (ModuleOpenNode open : this.opens) {
                open.accept(moduleVisitor);
            }
        }
        if (this.uses != null) {
            for (String use : this.uses) {
                moduleVisitor.visitUse(use);
            }
        }
        if (this.provides != null) {
            for (ModuleProvideNode provide : this.provides) {
                provide.accept(moduleVisitor);
            }
        }
    }
}

