/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree;

import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.TypePath;
import cn.taketoday.bytecode.tree.LabelNode;
import cn.taketoday.bytecode.tree.TypeAnnotationNode;
import cn.taketoday.bytecode.tree.Util;
import java.util.List;

public class LocalVariableAnnotationNode
extends TypeAnnotationNode {
    public List<LabelNode> start;
    public List<LabelNode> end;
    public List<Integer> index;

    public LocalVariableAnnotationNode(int typeRef, TypePath typePath, LabelNode[] start, LabelNode[] end, int[] index, String descriptor) {
        super(typeRef, typePath, descriptor);
        this.start = Util.asArrayList(start);
        this.end = Util.asArrayList(end);
        this.index = Util.asArrayList(index);
    }

    public void accept(MethodVisitor methodVisitor, boolean visible) {
        List<LabelNode> end = this.end;
        List<Integer> index = this.index;
        List<LabelNode> start = this.start;
        Label[] startLabels = new Label[start.size()];
        Label[] endLabels = new Label[end.size()];
        int[] indices = new int[index.size()];
        int n = startLabels.length;
        for (int i = 0; i < n; ++i) {
            startLabels[i] = start.get(i).getLabel();
            endLabels[i] = end.get(i).getLabel();
            indices[i] = index.get(i);
        }
        this.accept(methodVisitor.visitLocalVariableAnnotation(this.typeRef, this.typePath, startLabels, endLabels, indices, this.desc, visible));
    }
}

