/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree;

import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.tree.AbstractInsnNode;
import cn.taketoday.bytecode.tree.LabelNode;
import cn.taketoday.bytecode.tree.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List<Object> local;
    public List<Object> stack;

    private FrameNode() {
        super(-1);
    }

    public FrameNode(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        super(-1);
        this.type = type;
        switch (type) {
            case -1: 
            case 0: {
                this.local = Util.asArrayList(numLocal, local);
                this.stack = Util.asArrayList(numStack, stack);
                break;
            }
            case 1: {
                this.local = Util.asArrayList(numLocal, local);
                break;
            }
            case 2: {
                this.local = Util.asArrayList(numLocal);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.stack = Util.asArrayList(1, stack);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        switch (this.type) {
            case 1: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0, null);
                break;
            }
            case 2: {
                methodVisitor.visitFrame(this.type, this.local.size(), null, 0, null);
                break;
            }
            case 3: {
                methodVisitor.visitFrame(this.type, 0, null, 0, null);
                break;
            }
            case 4: {
                methodVisitor.visitFrame(this.type, 0, null, 1, FrameNode.asArray(this.stack));
                break;
            }
            case -1: 
            case 0: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> clonedLabels) {
        List<Object> stack;
        FrameNode clone = new FrameNode();
        clone.type = this.type;
        List<Object> local = this.local;
        if (local != null) {
            ArrayList<Object> cloneLocal = new ArrayList<Object>();
            clone.local = cloneLocal;
            for (Object localElement : local) {
                if (localElement instanceof LabelNode) {
                    localElement = clonedLabels.get(localElement);
                }
                cloneLocal.add(localElement);
            }
        }
        if ((stack = this.stack) != null) {
            ArrayList<Object> cloneStack = new ArrayList<Object>();
            clone.stack = cloneStack;
            for (Object stackElement : stack) {
                if (stackElement instanceof LabelNode) {
                    stackElement = clonedLabels.get(stackElement);
                }
                cloneStack.add(stackElement);
            }
        }
        return clone;
    }

    private static Object[] asArray(List<Object> list) {
        Object[] array = new Object[list.size()];
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            Object o = list.get(i);
            if (o instanceof LabelNode) {
                o = ((LabelNode)o).getLabel();
            }
            array[i] = o;
        }
        return array;
    }
}

