/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree;

import cn.taketoday.bytecode.AnnotationVisitor;
import cn.taketoday.bytecode.ClassValueHolder;
import cn.taketoday.bytecode.EnumValueHolder;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.tree.Util;
import java.util.ArrayList;

public class AnnotationNode
extends AnnotationVisitor {
    public String desc;
    public ArrayList<Object> values;

    public AnnotationNode(String descriptor) {
        this.desc = descriptor;
    }

    AnnotationNode(ArrayList<Object> values) {
        this.values = values;
    }

    @Override
    public void visit(String name, Object value) {
        ArrayList<Object> values = this.createIfNecessary();
        if (this.desc != null) {
            values.add(name);
        }
        if (value instanceof byte[]) {
            values.add(Util.asArrayList((byte[])value));
        } else if (value instanceof boolean[]) {
            values.add(Util.asArrayList((boolean[])value));
        } else if (value instanceof short[]) {
            values.add(Util.asArrayList((short[])value));
        } else if (value instanceof char[]) {
            values.add(Util.asArrayList((char[])value));
        } else if (value instanceof int[]) {
            values.add(Util.asArrayList((int[])value));
        } else if (value instanceof long[]) {
            values.add(Util.asArrayList((long[])value));
        } else if (value instanceof float[]) {
            values.add(Util.asArrayList((float[])value));
        } else if (value instanceof double[]) {
            values.add(Util.asArrayList((double[])value));
        } else {
            if (value instanceof Type) {
                value = new ClassValueHolder((Type)value);
            }
            values.add(value);
        }
    }

    @Override
    public void visitEnum(String name, String descriptor, String value) {
        ArrayList<Object> values = this.createIfNecessary();
        if (this.desc != null) {
            values.add(name);
        }
        values.add(new EnumValueHolder(descriptor, value));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
        ArrayList<Object> values = this.createIfNecessary();
        if (this.desc != null) {
            values.add(name);
        }
        AnnotationNode annotation = new AnnotationNode(descriptor);
        values.add(annotation);
        return annotation;
    }

    private ArrayList<Object> createIfNecessary() {
        ArrayList<Object> values = this.values;
        if (values == null) {
            this.values = values = new ArrayList(this.desc != null ? 2 : 1);
        }
        return values;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        ArrayList<Object> values = this.createIfNecessary();
        if (this.desc != null) {
            values.add(name);
        }
        ArrayList<Object> array = new ArrayList<Object>();
        values.add(array);
        return new AnnotationNode(array);
    }

    @Override
    public void visitEnd() {
        ArrayList<Object> values = this.values;
        if (values != null) {
            values.trimToSize();
        }
    }

    public void accept(AnnotationVisitor visitor) {
        if (visitor != null) {
            ArrayList<Object> values = this.values;
            if (values != null) {
                int n = values.size();
                for (int i = 0; i < n; i += 2) {
                    String name = (String)values.get(i);
                    Object value = values.get(i + 1);
                    AnnotationNode.accept(visitor, name, value);
                }
            }
            visitor.visitEnd();
        }
    }

    static void accept(AnnotationVisitor visitor, String name, Object value) {
        if (visitor != null) {
            if (value instanceof String[]) {
                String[] typeValue = (String[])value;
                visitor.visitEnum(name, typeValue[0], typeValue[1]);
            } else if (value instanceof AnnotationNode) {
                AnnotationNode annotationValue = (AnnotationNode)value;
                annotationValue.accept(visitor.visitAnnotation(name, annotationValue.desc));
            } else if (value instanceof ArrayList) {
                AnnotationVisitor arrayVisitor = visitor.visitArray(name);
                if (arrayVisitor != null) {
                    ArrayList arrayValue = (ArrayList)value;
                    for (Object o : arrayValue) {
                        AnnotationNode.accept(arrayVisitor, null, o);
                    }
                    arrayVisitor.visitEnd();
                }
            } else {
                visitor.visit(name, value);
            }
        }
    }
}

