/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform.impl;

import cn.taketoday.bytecode.core.ClassGenerator;
import cn.taketoday.bytecode.core.DefaultGeneratorStrategy;
import cn.taketoday.bytecode.transform.MethodFilter;
import cn.taketoday.bytecode.transform.MethodFilterTransformer;
import cn.taketoday.bytecode.transform.TransformingClassGenerator;
import cn.taketoday.bytecode.transform.impl.UndeclaredThrowableTransformer;
import java.lang.reflect.Modifier;

public class UndeclaredThrowableStrategy
extends DefaultGeneratorStrategy {
    private final Class wrapper;
    private static final MethodFilter TRANSFORM_FILTER = new MethodFilter(){

        @Override
        public boolean accept(int access, String name, String desc, String signature, String[] exceptions) {
            return !Modifier.isPrivate(access) && name.indexOf(36) < 0;
        }
    };

    public UndeclaredThrowableStrategy(Class wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    protected ClassGenerator transform(ClassGenerator cg) throws Exception {
        MethodFilterTransformer tr = new MethodFilterTransformer(TRANSFORM_FILTER, new UndeclaredThrowableTransformer(this.wrapper));
        return new TransformingClassGenerator(cg, tr);
    }
}

