/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform.impl;

import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.transform.ClassEmitterTransformer;
import cn.taketoday.bytecode.transform.impl.InterceptFieldCallback;
import cn.taketoday.bytecode.transform.impl.InterceptFieldEnabled;
import cn.taketoday.bytecode.transform.impl.InterceptFieldFilter;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Modifier;

public class InterceptFieldTransformer
extends ClassEmitterTransformer {
    private static final String CALLBACK_FIELD = "$todayReadWriteCallback";
    private static final Type ENABLED = Type.fromClass(InterceptFieldEnabled.class);
    private static final Type CALLBACK = Type.fromClass(InterceptFieldCallback.class);
    private static final MethodSignature ENABLED_SET = new MethodSignature(Type.VOID_TYPE, "setInterceptFieldCallback", CALLBACK);
    private static final MethodSignature ENABLED_GET = new MethodSignature(CALLBACK, "getInterceptFieldCallback", new Type[0]);
    private final InterceptFieldFilter filter;

    public InterceptFieldTransformer(InterceptFieldFilter filter) {
        this.filter = filter;
    }

    @Override
    public void beginClass(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (!Modifier.isInterface(access)) {
            super.beginClass(version, access, className, superType, Type.add(interfaces, ENABLED), sourceFile);
            super.declare_field(130, CALLBACK_FIELD, CALLBACK, null);
            CodeEmitter emitter = super.beginMethod(1, ENABLED_GET, new Type[0]);
            emitter.loadThis();
            emitter.getField(CALLBACK_FIELD);
            emitter.returnValue();
            emitter.end_method();
            emitter = super.beginMethod(1, ENABLED_SET, new Type[0]);
            emitter.loadThis();
            emitter.loadArg(0);
            emitter.putField(CALLBACK_FIELD);
            emitter.returnValue();
            emitter.end_method();
        } else {
            super.beginClass(version, access, className, superType, interfaces, sourceFile);
        }
    }

    @Override
    public void declare_field(int access, String name, Type type, Object value) {
        super.declare_field(access, name, type, value);
        if (!Modifier.isStatic(access)) {
            if (this.filter.acceptRead(this.getClassType(), name)) {
                this.addReadMethod(name, type);
            }
            if (this.filter.acceptWrite(this.getClassType(), name)) {
                this.addWriteMethod(name, type);
            }
        }
    }

    private void addReadMethod(String name, Type type) {
        CodeEmitter e = super.beginMethod(1, InterceptFieldTransformer.readMethodSig(name, type.getDescriptor()), new Type[0]);
        e.loadThis();
        e.getField(name);
        e.loadThis();
        e.invokeInterface(ENABLED, ENABLED_GET);
        Label intercept = e.newLabel();
        e.ifNonNull(intercept);
        e.returnValue();
        e.mark(intercept);
        Local result = e.newLocal(type);
        e.storeLocal(result);
        e.loadThis();
        e.invokeInterface(ENABLED, ENABLED_GET);
        e.loadThis();
        e.push(name);
        e.loadLocal(result);
        e.invokeInterface(CALLBACK, InterceptFieldTransformer.readCallbackSig(type));
        if (!type.isPrimitive()) {
            e.checkCast(type);
        }
        e.returnValue();
        e.end_method();
    }

    private void addWriteMethod(String name, Type type) {
        CodeEmitter e = super.beginMethod(1, InterceptFieldTransformer.writeMethodSig(name, type.getDescriptor()), new Type[0]);
        e.loadThis();
        e.dup();
        e.invokeInterface(ENABLED, ENABLED_GET);
        Label skip = e.newLabel();
        e.ifNull(skip);
        e.loadThis();
        e.invokeInterface(ENABLED, ENABLED_GET);
        e.loadThis();
        e.push(name);
        e.loadThis();
        e.getField(name);
        e.loadArg(0);
        e.invokeInterface(CALLBACK, InterceptFieldTransformer.writeCallbackSig(type));
        if (!type.isPrimitive()) {
            e.checkCast(type);
        }
        Label go = e.newLabel();
        e.goTo(go);
        e.mark(skip);
        e.loadArg(0);
        e.mark(go);
        e.putField(name);
        e.returnValue();
        e.end_method();
    }

    @Override
    public CodeEmitter beginMethod(int access, MethodSignature sig, Type ... exceptions) {
        return new CodeEmitter(super.beginMethod(access, sig, exceptions)){

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                Type towner = Type.fromInternalName(owner);
                switch (opcode) {
                    case 180: {
                        if (!InterceptFieldTransformer.this.filter.acceptRead(towner, name)) break;
                        this.helper(towner, InterceptFieldTransformer.readMethodSig(name, desc));
                        return;
                    }
                    case 181: {
                        if (!InterceptFieldTransformer.this.filter.acceptWrite(towner, name)) break;
                        this.helper(towner, InterceptFieldTransformer.writeMethodSig(name, desc));
                        return;
                    }
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            private void helper(Type owner, MethodSignature sig) {
                this.invokeVirtual(owner, sig);
            }
        };
    }

    private static MethodSignature readMethodSig(String name, String desc) {
        return new MethodSignature("$today_read_" + name, "()" + desc);
    }

    private static MethodSignature writeMethodSig(String name, String desc) {
        return new MethodSignature("$today_write_" + name, "(" + desc + ")V");
    }

    private static MethodSignature readCallbackSig(Type type) {
        Type remap = InterceptFieldTransformer.remap(type);
        return new MethodSignature(remap, "read" + InterceptFieldTransformer.callbackName(remap), Type.TYPE_OBJECT, Type.TYPE_STRING, remap);
    }

    private static MethodSignature writeCallbackSig(Type type) {
        Type remap = InterceptFieldTransformer.remap(type);
        return new MethodSignature(remap, "write" + InterceptFieldTransformer.callbackName(remap), Type.TYPE_OBJECT, Type.TYPE_STRING, remap, remap);
    }

    private static Type remap(Type type) {
        return switch (type.getSort()) {
            case 9, 10 -> Type.TYPE_OBJECT;
            default -> type;
        };
    }

    private static String callbackName(Type type) {
        return type == Type.TYPE_OBJECT ? "Object" : StringUtils.capitalize(type.getClassName());
    }
}

