/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform.impl;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.bytecode.transform.ClassEmitterTransformer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class AddDelegateTransformer
extends ClassEmitterTransformer {
    private static final String DELEGATE = "$todayDelegate";
    private static final MethodSignature CSTRUCT_OBJECT = MethodSignature.from("void <init>(Object)");
    private final Class[] delegateIf;
    private final Class delegateImpl;
    private final Type delegateType;

    public AddDelegateTransformer(Class[] delegateIf, Class delegateImpl) {
        try {
            delegateImpl.getConstructor(Object.class);
            this.delegateIf = delegateIf;
            this.delegateImpl = delegateImpl;
            this.delegateType = Type.fromClass(delegateImpl);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    @Override
    public void beginClass(int version, int access, String className, Type superType, Type[] interfaces, String sourceFile) {
        if (Modifier.isInterface(access)) {
            super.beginClass(version, access, className, superType, interfaces, sourceFile);
        } else {
            Type[] all = Type.add(interfaces, Type.getTypes(this.delegateIf));
            super.beginClass(version, access, className, superType, all, sourceFile);
            this.declare_field(130, DELEGATE, this.delegateType, null);
            for (Class aClass : this.delegateIf) {
                Method[] methods;
                for (Method method : methods = aClass.getMethods()) {
                    if (!Modifier.isAbstract(method.getModifiers())) continue;
                    this.addDelegate(method);
                }
            }
        }
    }

    @Override
    public CodeEmitter beginMethod(int access, MethodSignature sig, Type ... exceptions) {
        CodeEmitter e = super.beginMethod(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(e){
                private boolean transformInit;
                {
                    this.transformInit = true;
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    if (this.transformInit && opcode == 183) {
                        this.loadThis();
                        this.newInstance(AddDelegateTransformer.this.delegateType);
                        this.dup();
                        this.loadThis();
                        this.invokeConstructor(AddDelegateTransformer.this.delegateType, CSTRUCT_OBJECT);
                        this.putField(AddDelegateTransformer.DELEGATE);
                        this.transformInit = false;
                    }
                }
            };
        }
        return e;
    }

    private void addDelegate(Method m) {
        try {
            Method delegate = this.delegateImpl.getMethod(m.getName(), m.getParameterTypes());
            if (!delegate.getReturnType().getName().equals(m.getReturnType().getName())) {
                throw new IllegalArgumentException("Invalid delegate signature " + delegate);
            }
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
        MethodSignature sig = MethodSignature.from(m);
        Type[] exceptions = Type.getTypes(m.getExceptionTypes());
        CodeEmitter e = super.beginMethod(1, sig, exceptions);
        e.loadThis();
        e.getField(DELEGATE);
        e.loadArgs();
        e.invokeVirtual(this.delegateType, sig);
        e.returnValue();
        e.end_method();
    }
}

