/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform.impl;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.transform.ClassEmitterTransformer;
import cn.taketoday.util.StringUtils;

public class AccessFieldTransformer
extends ClassEmitterTransformer {
    private final Callback callback;

    public AccessFieldTransformer(Callback callback) {
        this.callback = callback;
    }

    @Override
    public void declare_field(int access, String name, Type type, Object value) {
        super.declare_field(access, name, type, value);
        String property = StringUtils.capitalize(this.callback.getPropertyName(this.getClassType(), name));
        if (property != null) {
            CodeEmitter e = this.beginMethod(1, new MethodSignature(type, "get" + property, Type.EMPTY_ARRAY), new Type[0]);
            e.loadThis();
            e.getField(name);
            e.returnValue();
            e.end_method();
            e = this.beginMethod(1, new MethodSignature(Type.VOID_TYPE, "set" + property, type), new Type[0]);
            e.loadThis();
            e.loadArg(0);
            e.putField(name);
            e.returnValue();
            e.end_method();
        }
    }

    public static interface Callback {
        public String getPropertyName(Type var1, String var2);
    }
}

