/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.transform.AbstractClassTransformer;
import cn.taketoday.bytecode.transform.ClassTransformer;

public class ClassTransformerChain
extends AbstractClassTransformer {
    private final ClassTransformer[] chain;

    public ClassTransformerChain(ClassTransformer[] chain) {
        this.chain = (ClassTransformer[])chain.clone();
    }

    @Override
    public void setTarget(ClassVisitor v) {
        ClassTransformer[] chain = this.chain;
        super.setTarget(chain[0]);
        ClassVisitor next = v;
        for (int i = chain.length - 1; i >= 0; --i) {
            chain[i].setTarget(next);
            next = chain[i];
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassTransformerChain{");
        ClassTransformer[] chain = this.chain;
        for (int i = 0; i < chain.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(chain[i].toString());
        }
        sb.append("}");
        return sb.toString();
    }
}

