/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform;

import cn.taketoday.bytecode.Attribute;
import cn.taketoday.bytecode.ClassReader;
import cn.taketoday.bytecode.core.ClassGenerator;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.bytecode.core.DebuggingClassWriter;
import cn.taketoday.bytecode.transform.ClassFilter;
import cn.taketoday.bytecode.transform.ClassReaderGenerator;
import cn.taketoday.lang.NonNull;
import cn.taketoday.util.ReflectionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;

public abstract class AbstractClassLoader
extends ClassLoader {
    private final ClassFilter filter;
    private final ClassLoader classPath;
    private static final ProtectionDomain DOMAIN = ReflectionUtils.getProtectionDomain(AbstractClassLoader.class);

    protected AbstractClassLoader(ClassLoader parent, ClassLoader classPath, ClassFilter filter) {
        super(parent);
        this.filter = filter;
        this.classPath = classPath;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null && loaded.getClassLoader() == this) {
            return loaded;
        }
        if (!this.filter.accept(name)) {
            return super.loadClass(name);
        }
        ClassReader reader = this.getClassReader(name);
        try {
            DebuggingClassWriter w = new DebuggingClassWriter(2);
            this.getGenerator(reader).generateClass(w);
            byte[] b = w.toByteArray();
            Class<?> c = super.defineClass(name, b, 0, b.length, DOMAIN);
            this.postProcess(c);
            return c;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    @NonNull
    private ClassReader getClassReader(String name) throws ClassNotFoundException {
        ClassReader classReader;
        block9: {
            InputStream is = this.classPath.getResourceAsStream(name.replace('.', '/').concat(".class"));
            try {
                if (is == null) {
                    throw new ClassNotFoundException(name);
                }
                classReader = new ClassReader(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(name + ":" + e.getMessage());
                }
            }
            is.close();
        }
        return classReader;
    }

    protected ClassGenerator getGenerator(ClassReader r) {
        return new ClassReaderGenerator(r, this.attributes(), this.getFlags());
    }

    protected int getFlags() {
        return 8;
    }

    protected Attribute[] attributes() {
        return null;
    }

    protected void postProcess(Class c) {
    }
}

