/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.reflect;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public abstract class ConstructorDelegate {
    protected ConstructorDelegate() {
    }

    public static <T> T create(Class targetClass, Class<T> iface) {
        Generator gen = new Generator();
        gen.setTargetClass(targetClass);
        gen.setInterface(iface);
        return (T)gen.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final Type CONSTRUCTOR_DELEGATE = Type.fromClass(ConstructorDelegate.class);
        private Class iface;
        private Class targetClass;

        public Generator() {
            super(ConstructorDelegate.class);
        }

        public void setInterface(Class iface) {
            this.iface = iface;
        }

        public void setTargetClass(Class targetClass) {
            this.targetClass = targetClass;
            this.setNeighbor(targetClass);
        }

        public ConstructorDelegate create() {
            this.setNamePrefix(this.targetClass.getName());
            ConstructorKey key = new ConstructorKey(this.iface.getName(), this.targetClass.getName());
            return (ConstructorDelegate)super.create(key);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.targetClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.targetClass);
        }

        @Override
        public void generateClass(ClassVisitor v) {
            Constructor constructor;
            this.setNamePrefix(this.targetClass.getName());
            Method newInstance = CglibReflectUtils.findNewInstance(this.iface);
            if (!newInstance.getReturnType().isAssignableFrom(this.targetClass)) {
                throw new IllegalArgumentException("incompatible return type");
            }
            try {
                constructor = this.targetClass.getDeclaredConstructor(newInstance.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("interface does not match any known constructor");
            }
            ClassEmitter ce = new ClassEmitter(v);
            ce.beginClass(52, 1, this.getClassName(), CONSTRUCTOR_DELEGATE, Type.array(Type.fromClass(this.iface)), "<cglibGenerated>");
            Type declaring = Type.fromClass(constructor.getDeclaringClass());
            EmitUtils.nullConstructor(ce);
            CodeEmitter e = ce.beginMethod(1, MethodSignature.from(newInstance), Type.getExceptionTypes(newInstance));
            e.newInstance(declaring);
            e.dup();
            e.loadArgs();
            e.invokeConstructor(declaring, MethodSignature.from(constructor));
            e.returnValue();
            e.end_method();
            ce.endClass();
        }

        protected Object firstInstance(Class type) {
            return ReflectionUtils.newInstance(type);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    record ConstructorKey(String declaring, String iface) {
    }
}

