/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.ClassInfo;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.core.ObjectSwitchCallback;
import cn.taketoday.bytecode.proxy.CallbackGenerator;
import cn.taketoday.bytecode.proxy.MethodInterceptor;
import cn.taketoday.bytecode.proxy.MethodProxy;
import cn.taketoday.core.MultiValueMap;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String FIND_PROXY_NAME = "today$FindMethodProxy";
    private static final Type METHOD = Type.fromClass(Method.class);
    private static final Type ABSTRACT_METHOD_ERROR = Type.fromClass(AbstractMethodError.class);
    private static final Type REFLECT_UTILS = Type.fromClass(CglibReflectUtils.class);
    private static final Type METHOD_PROXY = Type.fromClass(MethodProxy.class);
    private static final Type METHOD_INTERCEPTOR = Type.fromClass(MethodInterceptor.class);
    private static final MethodSignature GET_DECLARED_METHODS = MethodSignature.from("java.lang.reflect.Method[] getDeclaredMethods()");
    private static final MethodSignature FIND_METHODS = MethodSignature.from("java.lang.reflect.Method[] findMethods(String[], java.lang.reflect.Method[])");
    private static final MethodSignature MAKE_PROXY = new MethodSignature(METHOD_PROXY, "create", Type.TYPE_CLASS, Type.TYPE_CLASS, Type.TYPE_STRING, Type.TYPE_STRING, Type.TYPE_STRING);
    private static final MethodSignature INTERCEPT = new MethodSignature(Type.TYPE_OBJECT, "intercept", Type.TYPE_OBJECT, METHOD, Type.TYPE_OBJECT_ARRAY, METHOD_PROXY);
    private static final MethodSignature FIND_PROXY = new MethodSignature(METHOD_PROXY, "today$FindMethodProxy", Type.TYPE_SIGNATURE);

    MethodInterceptorGenerator() {
    }

    private String getMethodField(MethodSignature impl) {
        return impl.getName() + "$Method";
    }

    private String getMethodProxyField(MethodSignature impl) {
        return impl.getName() + "$Proxy";
    }

    @Override
    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List<MethodInfo> methods) {
        HashMap<String, String> sigMap = new HashMap<String, String>();
        for (MethodInfo method : methods) {
            MethodSignature sig = method.getSignature();
            MethodSignature impl = context.getImplSignature(method);
            String methodField = this.getMethodField(impl);
            String methodProxyField = this.getMethodProxyField(impl);
            sigMap.put(sig.toString(), methodProxyField);
            ce.declare_field(26, methodField, METHOD, null);
            ce.declare_field(26, methodProxyField, METHOD_PROXY, null);
            CodeEmitter codeEmitter = ce.beginMethod(16, impl, method.getExceptionTypes());
            MethodInterceptorGenerator.superHelper(codeEmitter, method, context);
            codeEmitter.returnValue();
            codeEmitter.end_method();
            codeEmitter = context.beginMethod(ce, method);
            Label nullInterceptor = codeEmitter.newLabel();
            context.emitCallback(codeEmitter, context.getIndex(method));
            codeEmitter.dup();
            codeEmitter.ifNull(nullInterceptor);
            codeEmitter.loadThis();
            codeEmitter.getField(methodField);
            if (sig.getArgumentTypes().length == 0) {
                EmitUtils.loadEmptyArguments(codeEmitter);
            } else {
                codeEmitter.loadArgArray();
            }
            codeEmitter.getField(methodProxyField);
            codeEmitter.invokeInterface(METHOD_INTERCEPTOR, INTERCEPT);
            codeEmitter.unbox_or_zero(sig.getReturnType());
            codeEmitter.returnValue();
            codeEmitter.mark(nullInterceptor);
            MethodInterceptorGenerator.superHelper(codeEmitter, method, context);
            codeEmitter.returnValue();
            codeEmitter.end_method();
        }
        this.generateFindProxy(ce, sigMap);
    }

    private static void superHelper(CodeEmitter e, MethodInfo method, CallbackGenerator.Context context) {
        if (Modifier.isAbstract(method.getModifiers())) {
            e.throwException(ABSTRACT_METHOD_ERROR, method + " is abstract");
        } else {
            e.loadThis();
            context.emitLoadArgsAndInvoke(e, method);
        }
    }

    @Override
    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List<MethodInfo> methods) throws Exception {
        Local thisClass = e.newLocal();
        Local declaringClass = e.newLocal();
        EmitUtils.loadClassThis(e);
        e.storeLocal(thisClass);
        MultiValueMap<ClassInfo, MethodInfo> methodsByClass = CollectionUtils.buckets(methods, MethodInfo::getClassInfo);
        for (Map.Entry entry : methodsByClass.entrySet()) {
            int index;
            ClassInfo classInfo = (ClassInfo)entry.getKey();
            List classMethods = (List)entry.getValue();
            int size = classMethods.size();
            e.push(2 * size);
            e.newArray(Type.TYPE_STRING);
            for (index = 0; index < size; ++index) {
                MethodSignature sig = ((MethodInfo)classMethods.get(index)).getSignature();
                e.dup();
                e.push(2 * index);
                e.push(sig.getName());
                e.aastore();
                e.dup();
                e.push(2 * index + 1);
                e.push(sig.getDescriptor());
                e.aastore();
            }
            EmitUtils.loadClass(e, classInfo.getType());
            e.dup();
            e.storeLocal(declaringClass);
            e.invokeVirtual(Type.TYPE_CLASS, GET_DECLARED_METHODS);
            e.invokeStatic(REFLECT_UTILS, FIND_METHODS);
            for (index = 0; index < size; ++index) {
                MethodInfo method = (MethodInfo)classMethods.get(index);
                MethodSignature sig = method.getSignature();
                MethodSignature impl = context.getImplSignature(method);
                e.dup();
                e.push(index);
                e.arrayLoad(METHOD);
                e.putField(this.getMethodField(impl));
                e.loadLocal(declaringClass);
                e.loadLocal(thisClass);
                e.push(sig.getDescriptor());
                e.push(sig.getName());
                e.push(impl.getName());
                e.invokeStatic(METHOD_PROXY, MAKE_PROXY);
                e.putField(this.getMethodProxyField(impl));
            }
            e.pop();
        }
    }

    public void generateFindProxy(ClassEmitter ce, final Map<String, String> sigMap) {
        final CodeEmitter e = ce.beginMethod(9, FIND_PROXY, new Type[0]);
        e.loadArg(0);
        e.invokeVirtual(Type.TYPE_OBJECT, MethodSignature.TO_STRING);
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                e.getField((String)sigMap.get(key));
                e.returnValue();
            }

            @Override
            public void processDefault() {
                e.aconst_null();
                e.returnValue();
            }
        };
        EmitUtils.stringSwitch(e, StringUtils.toStringArray(sigMap.keySet()), 1, callback);
        e.end_method();
    }
}

