/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.proxy.Callback;
import cn.taketoday.bytecode.proxy.CallbackGenerator;
import cn.taketoday.bytecode.proxy.Dispatcher;
import cn.taketoday.bytecode.proxy.DispatcherGenerator;
import cn.taketoday.bytecode.proxy.FixedValue;
import cn.taketoday.bytecode.proxy.FixedValueGenerator;
import cn.taketoday.bytecode.proxy.InvocationHandler;
import cn.taketoday.bytecode.proxy.InvocationHandlerGenerator;
import cn.taketoday.bytecode.proxy.LazyLoader;
import cn.taketoday.bytecode.proxy.LazyLoaderGenerator;
import cn.taketoday.bytecode.proxy.MethodInterceptor;
import cn.taketoday.bytecode.proxy.MethodInterceptorGenerator;
import cn.taketoday.bytecode.proxy.NoOp;
import cn.taketoday.bytecode.proxy.NoOpGenerator;
import cn.taketoday.bytecode.proxy.ProxyRefDispatcher;

class CallbackInfo {
    private final Class<?> cls;
    private final Type type;
    private final CallbackGenerator generator;
    private static final CallbackInfo[] CALLBACKS = new CallbackInfo[]{new CallbackInfo(NoOp.class, NoOpGenerator.INSTANCE), new CallbackInfo(MethodInterceptor.class, MethodInterceptorGenerator.INSTANCE), new CallbackInfo(InvocationHandler.class, InvocationHandlerGenerator.INSTANCE), new CallbackInfo(LazyLoader.class, LazyLoaderGenerator.INSTANCE), new CallbackInfo(Dispatcher.class, DispatcherGenerator.INSTANCE), new CallbackInfo(FixedValue.class, FixedValueGenerator.INSTANCE), new CallbackInfo(ProxyRefDispatcher.class, DispatcherGenerator.PROXY_REF_INSTANCE)};

    private CallbackInfo(Class<?> cls, CallbackGenerator generator) {
        this.cls = cls;
        this.generator = generator;
        this.type = Type.fromClass(cls);
    }

    private static Type determineType(Callback callback, boolean checkAll) {
        if (callback == null) {
            throw new IllegalStateException("Callback is null");
        }
        return CallbackInfo.determineType(callback.getClass(), checkAll);
    }

    private static Type determineType(Class<?> callbackType, boolean checkAll) {
        Class<?> cur = null;
        Type type = null;
        for (CallbackInfo info : CALLBACKS) {
            if (!info.cls.isAssignableFrom(callbackType)) continue;
            if (cur != null) {
                throw new IllegalStateException("Callback implements both " + cur + " and " + info.cls);
            }
            cur = info.cls;
            type = info.type;
            if (!checkAll) break;
        }
        if (cur == null) {
            throw new IllegalStateException("Unknown callback type " + callbackType);
        }
        return type;
    }

    private static CallbackGenerator getGenerator(Type callbackType) {
        for (CallbackInfo info : CALLBACKS) {
            if (!info.type.equals(callbackType)) continue;
            return info.generator;
        }
        throw new IllegalStateException("Unknown callback type " + callbackType);
    }

    public static Type[] determineTypes(Class<?>[] callbackTypes) {
        return CallbackInfo.determineTypes(callbackTypes, true);
    }

    public static Type[] determineTypes(Class<?>[] callbackTypes, boolean checkAll) {
        Type[] types = new Type[callbackTypes.length];
        int i = 0;
        for (Class<?> type : callbackTypes) {
            types[i++] = CallbackInfo.determineType(type, checkAll);
        }
        return types;
    }

    public static Type[] determineTypes(Callback[] callbacks) {
        return CallbackInfo.determineTypes(callbacks, true);
    }

    public static Type[] determineTypes(Callback[] callbacks, boolean checkAll) {
        Type[] types = new Type[callbacks.length];
        int i = 0;
        for (Callback callback : callbacks) {
            types[i++] = CallbackInfo.determineType(callback, checkAll);
        }
        return types;
    }

    public static CallbackGenerator[] getGenerators(Type[] callbackTypes) {
        CallbackGenerator[] generators = new CallbackGenerator[callbackTypes.length];
        int i = 0;
        for (Type callbackType : callbackTypes) {
            generators[i++] = CallbackInfo.getGenerator(callbackType);
        }
        return generators;
    }
}

