/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.util.ClassUtils;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

public class VisibilityPredicate
implements Predicate<Executable> {
    private final String pkg;
    private final boolean protectedOk;
    private final boolean samePackageOk;

    public VisibilityPredicate(Class<?> source, boolean protectedOk) {
        this.protectedOk = protectedOk;
        this.samePackageOk = source.getClassLoader() != null;
        this.pkg = ClassUtils.getPackageName(source);
    }

    @Override
    public boolean test(Executable member) {
        int mod = member.getModifiers();
        if (Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod) && this.protectedOk) {
            return true;
        }
        return this.samePackageOk && this.pkg.equals(ClassUtils.getPackageName(member.getDeclaringClass()));
    }
}

