/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Function;

final class LoadingCache<K, KK, V> {
    public final Function<K, V> loader;
    public final Function<K, KK> keyMapper;
    public final ConcurrentHashMap<KK, Object> map = new ConcurrentHashMap();

    public LoadingCache(Function<K, KK> keyMapper, Function<K, V> loader) {
        this.loader = loader;
        this.keyMapper = keyMapper;
    }

    public V get(K key) {
        KK cacheKey = this.keyMapper.apply(key);
        Object v = this.map.get(cacheKey);
        if (v != null && !(v instanceof FutureTask)) {
            return (V)v;
        }
        return this.createEntry(key, cacheKey, v);
    }

    private V createEntry(K key, KK cacheKey, Object v) {
        FutureTask<Object> task;
        boolean created = false;
        if (v != null) {
            task = (FutureTask<Object>)v;
        } else {
            task = new FutureTask<Object>(() -> this.loader.apply(key));
            FutureTask<Object> prevTask = this.map.putIfAbsent(cacheKey, task);
            if (prevTask == null) {
                created = true;
                task.run();
            } else if (prevTask instanceof FutureTask) {
                task = prevTask;
            } else {
                return (V)prevTask;
            }
        }
        try {
            Object result = task.get();
            if (created) {
                this.map.put(cacheKey, result);
            }
            return result;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while loading cache item", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Unable to load cache item", cause);
        }
    }
}

