/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.FieldVisitor;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassInfo;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.transform.ClassTransformer;
import cn.taketoday.lang.Nullable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ClassEmitter
extends ClassTransformer {
    private ClassInfo classInfo;
    private Map<String, FieldInfo> fieldInfo;
    private static int hookCounter;
    private MethodVisitor rawStaticInit;
    private CodeEmitter staticInit;
    private CodeEmitter staticHook;
    private MethodSignature staticHookSig;

    public ClassEmitter(ClassVisitor cv) {
        this.setTarget(cv);
    }

    public ClassEmitter() {
    }

    @Override
    public void setTarget(ClassVisitor cv) {
        this.cv = cv;
        this.fieldInfo = new HashMap<String, FieldInfo>();
        this.staticHook = null;
        this.staticInit = null;
        this.staticHookSig = null;
    }

    private static synchronized int getNextHook() {
        return ++hookCounter;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void beginClass(int access, String className, Class<?> superType, Class<?> ... interfaces) {
        this.beginClass(52, access, className, Type.fromClass(superType), Type.getTypes(interfaces), "<cglibGenerated>");
    }

    public void beginClass(int access, String className, Class<?> superType, String source, Class<?> ... interfaces) {
        this.beginClass(52, access, className, Type.fromClass(superType), Type.getTypes(interfaces), source);
    }

    public void beginClass(int version, int access, String className, Class<?> superType, String source, Class<?> ... interfaces) {
        this.beginClass(version, access, className, Type.fromClass(superType), Type.getTypes(interfaces), source);
    }

    public void beginClass(int version, int access, String className, Type superType, String source, Type ... interfaces) {
        this.beginClass(version, access, className, superType, interfaces, source);
    }

    public void beginClass(int version, final int access, String className, final @Nullable Type superType, final Type[] interfaces, @Nullable String source) {
        final Type classType = Type.fromDescriptor("L" + className.replace('.', '/') + ";");
        this.classInfo = new ClassInfo(){

            @Override
            public Type getType() {
                return classType;
            }

            @Override
            public Type getSuperType() {
                return superType != null ? superType : Type.TYPE_OBJECT;
            }

            @Override
            public Type[] getInterfaces() {
                return interfaces;
            }

            @Override
            public int getModifiers() {
                return access;
            }
        };
        this.cv.visit(version, access, this.classInfo.getType().getInternalName(), null, this.classInfo.getSuperType().getInternalName(), Type.toInternalNames(interfaces));
        if (source != null) {
            this.cv.visitSource(source, null);
        }
        this.init();
    }

    public void beginClass(int access, String name, String superName, String ... interfaces) {
        this.beginClass(52, access, name, superName, interfaces);
    }

    public void beginClass(int version, int access, String name, String superName, String ... interfaces) {
        this.beginClass(version, access, name, "<cglibGenerated>", superName, interfaces);
    }

    public void beginClass(int version, final int access, String name, String source, String superName, String ... interfaces) {
        final Type superType = Type.fromDescriptor(superName);
        final Type[] array = Type.getTypes(interfaces);
        final Type type = Type.fromInternalName(name.replace('.', '/'));
        this.classInfo = new ClassInfo(){

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public Type getSuperType() {
                return superType;
            }

            @Override
            public Type[] getInterfaces() {
                return array;
            }

            @Override
            public int getModifiers() {
                return access;
            }
        };
        this.cv.visit(version, access, name, null, superType.getInternalName(), Type.toInternalNames(array));
        if (source != null) {
            this.cv.visitSource(source, null);
        }
        this.init();
    }

    public CodeEmitter getStaticHook() {
        if (Modifier.isInterface(this.getAccess())) {
            throw new IllegalStateException("static hook is invalid for this class");
        }
        if (this.staticHook == null) {
            this.staticHookSig = new MethodSignature("today$StaticHook" + ClassEmitter.getNextHook(), "()V");
            this.staticHook = this.beginMethod(8, this.staticHookSig, new Type[0]);
            if (this.staticInit != null) {
                this.staticInit.invoke_static_this(this.staticHookSig);
            }
        }
        return this.staticHook;
    }

    protected void init() {
    }

    public int getAccess() {
        return this.classInfo.getModifiers();
    }

    public Type getClassType() {
        return this.classInfo.getType();
    }

    public Type getSuperType() {
        return this.classInfo.getSuperType();
    }

    public void endClass() {
        if (this.staticHook != null && this.staticInit == null) {
            this.begin_static();
        }
        if (this.staticInit != null) {
            if (this.staticHook != null) {
                this.staticHook.returnValue();
                this.staticHook.end_method();
            }
            this.rawStaticInit.visitInsn(177);
            this.rawStaticInit.visitMaxs(0, 0);
            this.staticHook = null;
            this.staticInit = null;
            this.staticHookSig = null;
        }
        this.cv.visitEnd();
    }

    public CodeEmitter beginMethod(int access, Method method) {
        return this.beginMethod(access, MethodSignature.from(method), Type.getExceptionTypes(method));
    }

    public CodeEmitter beginMethod(int access, MethodSignature sig, Type ... exceptions) {
        if (this.classInfo == null) {
            throw new IllegalStateException("classInfo is null! " + this);
        }
        MethodVisitor visitor = this.cv.visitMethod(access, sig.getName(), sig.getDescriptor(), null, Type.toInternalNames(exceptions));
        if (sig.equals(MethodSignature.SIG_STATIC) && !Modifier.isInterface(this.getAccess())) {
            return this.begin_static(true, visitor);
        }
        if (sig.equals(this.staticHookSig)) {
            return new CodeEmitter(this, visitor, access, sig, exceptions){

                @Override
                public boolean isStaticHook() {
                    return true;
                }
            };
        }
        return new CodeEmitter(this, visitor, access, sig, exceptions);
    }

    public CodeEmitter begin_static() {
        return this.begin_static(true);
    }

    public CodeEmitter begin_static(boolean hook) {
        MethodSignature sigStatic = MethodSignature.SIG_STATIC;
        return this.begin_static(hook, this.cv.visitMethod(8, sigStatic.getName(), sigStatic.getDescriptor(), null, null));
    }

    public CodeEmitter begin_static(boolean hook, MethodVisitor visitor) {
        this.rawStaticInit = visitor;
        MethodVisitor wrapped = new MethodVisitor(visitor){

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
            }

            @Override
            public void visitInsn(int insn) {
                if (insn != 177) {
                    super.visitInsn(insn);
                }
            }
        };
        this.staticInit = new CodeEmitter(this, wrapped, 8, MethodSignature.SIG_STATIC, null);
        if (hook) {
            if (this.staticHook == null) {
                this.getStaticHook();
            } else {
                this.staticInit.invoke_static_this(this.staticHookSig);
            }
        }
        return this.staticInit;
    }

    public void declare_field(int access, String name, Type type, Object value) {
        FieldInfo existing = this.fieldInfo.get(name);
        FieldInfo info = new FieldInfo(access, name, type, value);
        if (existing != null) {
            if (!info.equals(existing)) {
                throw new IllegalArgumentException("Field \"" + name + "\" has been declared differently");
            }
        } else {
            this.fieldInfo.put(name, info);
            this.cv.visitField(access, name, type.getDescriptor(), null, value);
        }
    }

    public boolean isFieldDeclared(String name) {
        return this.fieldInfo.get(name) != null;
    }

    FieldInfo getFieldInfo(String name) {
        FieldInfo field = this.fieldInfo.get(name);
        if (field == null) {
            throw new IllegalArgumentException("Field " + name + " is not declared in " + this.getClassType().getClassName());
        }
        return field;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.beginClass(version, access, name.replace('/', '.'), Type.fromInternalName(superName), Type.fromInternalNames(interfaces), null);
    }

    @Override
    public void visitEnd() {
        this.endClass();
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.declare_field(access, name, Type.fromDescriptor(desc), value);
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return this.beginMethod(access, new MethodSignature(name, desc), Type.fromInternalNames(exceptions));
    }

    static class FieldInfo {
        public final int access;
        public final Type type;
        public final String name;
        public final Object value;

        public FieldInfo(int access, String name, Type type, Object value) {
            this.access = access;
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldInfo)) {
                return false;
            }
            FieldInfo other = (FieldInfo)o;
            if (this.access != other.access || !this.name.equals(other.name) || !this.type.equals(other.type)) {
                return false;
            }
            Object value = this.value;
            if (value == null ^ other.value == null) {
                return false;
            }
            return value == null || value.equals(other.value);
        }

        public int hashCode() {
            return this.access ^ this.name.hashCode() ^ this.type.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

