/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ReflectionUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public abstract class CglibReflectUtils {
    @Nullable
    public static String[] getNames(Class[] classes) {
        if (classes == null) {
            return null;
        }
        int i = 0;
        String[] names = new String[classes.length];
        for (Class clazz : classes) {
            names[i++] = clazz.getName();
        }
        return names;
    }

    public static Class[] getClasses(Object[] objects) {
        int i = 0;
        Class[] classes = new Class[objects.length];
        for (Object obj : objects) {
            classes[i++] = obj.getClass();
        }
        return classes;
    }

    public static Method findNewInstance(Class<?> iface) {
        Method m = ReflectionUtils.findFunctionalInterfaceMethod(iface);
        if (m.getName().equals("newInstance")) {
            return m;
        }
        throw new IllegalArgumentException(iface + " missing newInstance method");
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] properties, boolean read, boolean write) {
        HashSet<Method> methods = new HashSet<Method>();
        for (PropertyDescriptor pd : properties) {
            if (read) {
                methods.add(pd.getReadMethod());
            }
            if (!write) continue;
            methods.add(pd.getWriteMethod());
        }
        methods.remove(null);
        return ReflectionUtils.toMethodArray(methods);
    }

    public static PropertyDescriptor[] getBeanProperties(Class<?> type) {
        return CglibReflectUtils.getPropertiesHelper(type, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class<?> type) {
        return CglibReflectUtils.getPropertiesHelper(type, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class<?> type) {
        return CglibReflectUtils.getPropertiesHelper(type, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class<?> type, boolean read, boolean write) {
        try {
            PropertyDescriptor[] all = Introspector.getBeanInfo(type, Object.class).getPropertyDescriptors();
            if (read && write) {
                return all;
            }
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(all.length);
            for (PropertyDescriptor pd : all) {
                if ((!read || pd.getReadMethod() == null) && (!write || pd.getWriteMethod() == null)) continue;
                properties.add(pd);
            }
            return properties.toArray(new PropertyDescriptor[properties.size()]);
        }
        catch (IntrospectionException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static int findPackageProtected(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (Modifier.isPublic(classes[i].getModifiers())) continue;
            return i;
        }
        return 0;
    }

    public static Method[] findMethods(String[] namesAndDescriptors, Method[] methods) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method method : methods) {
            map.put(method.getName().concat(Type.getMethodDescriptor(method)), method);
        }
        Method[] result = new Method[namesAndDescriptors.length / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Method)map.get(namesAndDescriptors[i * 2] + namesAndDescriptors[i * 2 + 1]);
        }
        return result;
    }
}

