/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.tree.MethodNode;
import cn.taketoday.bytecode.tree.TryCatchBlockNode;
import java.util.Comparator;
import java.util.List;

public class TryCatchBlockSorter
extends MethodNode {
    public TryCatchBlockSorter(MethodVisitor methodVisitor, int access, String name, String descriptor, String signature, String[] exceptions) {
        super(access, name, descriptor, signature, exceptions);
        this.mv = methodVisitor;
    }

    @Override
    public void visitEnd() {
        List tryCatchBlocks = this.tryCatchBlocks;
        if (tryCatchBlocks != null) {
            tryCatchBlocks.sort(new Comparator<TryCatchBlockNode>(){

                @Override
                public int compare(TryCatchBlockNode tryCatchBlockNode1, TryCatchBlockNode tryCatchBlockNode2) {
                    return this.blockLength(tryCatchBlockNode1) - this.blockLength(tryCatchBlockNode2);
                }

                private int blockLength(TryCatchBlockNode tryCatchBlockNode) {
                    int endIndex = TryCatchBlockSorter.this.instructions.indexOf(tryCatchBlockNode.end);
                    int startIndex = TryCatchBlockSorter.this.instructions.indexOf(tryCatchBlockNode.start);
                    return endIndex - startIndex;
                }
            });
            int size = tryCatchBlocks.size();
            for (int i = 0; i < size; ++i) {
                ((TryCatchBlockNode)tryCatchBlocks.get(i)).updateIndex(i);
            }
        }
        if (this.mv != null) {
            this.accept(this.mv);
        }
    }
}

