/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.AnnotationVisitor;
import cn.taketoday.bytecode.RecordComponentVisitor;
import cn.taketoday.bytecode.TypePath;
import cn.taketoday.bytecode.commons.AnnotationRemapper;
import cn.taketoday.bytecode.commons.Remapper;
import cn.taketoday.lang.Nullable;

public class RecordComponentRemapper
extends RecordComponentVisitor {
    protected final Remapper remapper;

    public RecordComponentRemapper(RecordComponentVisitor recordComponentVisitor, Remapper remapper) {
        super(recordComponentVisitor);
        this.remapper = remapper;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor), visible);
        return this.createAnnotationRemapper(descriptor, annotationVisitor);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath, this.remapper.mapDesc(descriptor), visible);
        return this.createAnnotationRemapper(descriptor, annotationVisitor);
    }

    @Nullable
    protected AnnotationVisitor createAnnotationRemapper(String descriptor, @Nullable AnnotationVisitor annotationVisitor) {
        if (annotationVisitor == null) {
            return null;
        }
        return new AnnotationRemapper(descriptor, annotationVisitor, this.remapper);
    }
}

