/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.ModuleVisitor;
import cn.taketoday.bytecode.commons.Remapper;

public class ModuleRemapper
extends ModuleVisitor {
    protected final Remapper remapper;

    public ModuleRemapper(ModuleVisitor moduleVisitor, Remapper remapper) {
        super(moduleVisitor);
        this.remapper = remapper;
    }

    @Override
    public void visitMainClass(String mainClass) {
        super.visitMainClass(this.remapper.mapType(mainClass));
    }

    @Override
    public void visitPackage(String packaze) {
        super.visitPackage(this.remapper.mapPackageName(packaze));
    }

    @Override
    public void visitRequire(String module, int access, String version) {
        super.visitRequire(this.remapper.mapModuleName(module), access, version);
    }

    @Override
    public void visitExport(String packaze, int access, String ... modules) {
        String[] remappedModules = null;
        Remapper remapper = this.remapper;
        if (modules != null) {
            remappedModules = new String[modules.length];
            for (int i = 0; i < modules.length; ++i) {
                remappedModules[i] = remapper.mapModuleName(modules[i]);
            }
        }
        super.visitExport(remapper.mapPackageName(packaze), access, remappedModules);
    }

    @Override
    public void visitOpen(String packaze, int access, String ... modules) {
        String[] remappedModules = null;
        Remapper remapper = this.remapper;
        if (modules != null) {
            remappedModules = new String[modules.length];
            for (int i = 0; i < modules.length; ++i) {
                remappedModules[i] = remapper.mapModuleName(modules[i]);
            }
        }
        super.visitOpen(remapper.mapPackageName(packaze), access, remappedModules);
    }

    @Override
    public void visitUse(String service) {
        super.visitUse(this.remapper.mapType(service));
    }

    @Override
    public void visitProvide(String service, String ... providers) {
        Remapper remapper = this.remapper;
        String[] remappedProviders = new String[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            remappedProviders[i] = remapper.mapType(providers[i]);
        }
        super.visitProvide(remapper.mapType(service), remappedProviders);
    }
}

