/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.ConstantDynamic;
import cn.taketoday.bytecode.Handle;
import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.InstructionAdapter;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.LocalVariablesSorter;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.commons.TableSwitchGenerator;
import java.util.ArrayList;
import java.util.Arrays;

public class GeneratorAdapter
extends LocalVariablesSorter {
    private static final String CLASS_DESCRIPTOR = "Ljava/lang/Class;";
    public static final int ADD = 96;
    public static final int SUB = 100;
    public static final int MUL = 104;
    public static final int DIV = 108;
    public static final int REM = 112;
    public static final int NEG = 116;
    public static final int SHL = 120;
    public static final int SHR = 122;
    public static final int USHR = 124;
    public static final int AND = 126;
    public static final int OR = 128;
    public static final int XOR = 130;
    public static final int EQ = 153;
    public static final int NE = 154;
    public static final int LT = 155;
    public static final int GE = 156;
    public static final int GT = 157;
    public static final int LE = 158;
    private final int access;
    private final String name;
    private final Type returnType;
    private final ArrayList<Type> localTypes;

    public GeneratorAdapter(MethodVisitor methodVisitor, int access, String name, String descriptor) {
        super(access, descriptor, methodVisitor);
        this.name = name;
        this.access = access;
        this.localTypes = new ArrayList();
        this.returnType = Type.forReturnType(descriptor);
    }

    public GeneratorAdapter(GeneratorAdapter other) {
        super(other);
        this.name = other.name;
        this.access = other.access;
        this.returnType = other.returnType;
        this.localTypes = other.localTypes;
    }

    public GeneratorAdapter(int access, MethodSignature method, MethodVisitor methodVisitor) {
        this(methodVisitor, access, method.getName(), method.getDescriptor());
    }

    public GeneratorAdapter(int access, MethodSignature method, String signature, Type[] exceptions, ClassVisitor classVisitor) {
        this(access, method, classVisitor.visitMethod(access, method.getName(), method.getDescriptor(), signature, exceptions == null ? null : GeneratorAdapter.getInternalNames(exceptions)));
    }

    private static String[] getInternalNames(Type[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = types[i].getInternalName();
        }
        return names;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void push(boolean value) {
        this.push(value ? 1 : 0);
    }

    public void push(int value) {
        InstructionAdapter.push(this.mv, value);
    }

    public void push(long value) {
        if (value == 0L || value == 1L) {
            this.mv.visitInsn(9 + (int)value);
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void push(float value) {
        int bits = Float.floatToIntBits(value);
        if ((long)bits == 0L || bits == 1065353216 || bits == 0x40000000) {
            this.mv.visitInsn(11 + (int)value);
        } else {
            this.mv.visitLdcInsn(Float.valueOf(value));
        }
    }

    public void push(double value) {
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L || bits == 0x3FF0000000000000L) {
            this.mv.visitInsn(14 + (int)value);
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void push(String value) {
        if (value == null) {
            this.aconst_null();
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void aconst_null() {
        this.mv.visitInsn(1);
    }

    public void push(Type value) {
        if (value == null) {
            this.aconst_null();
        } else {
            switch (value.getSort()) {
                case 3: {
                    this.mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 7: {
                    this.mv.visitFieldInsn(178, "java/lang/Long", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 4: {
                    this.mv.visitFieldInsn(178, "java/lang/Short", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 5: {
                    this.mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 6: {
                    this.mv.visitFieldInsn(178, "java/lang/Float", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 8: {
                    this.mv.visitFieldInsn(178, "java/lang/Double", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 2: {
                    this.mv.visitFieldInsn(178, "java/lang/Character", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                case 1: {
                    this.mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", CLASS_DESCRIPTOR);
                    break;
                }
                default: {
                    this.mv.visitLdcInsn(value);
                }
            }
        }
    }

    public void push(Handle handle) {
        if (handle == null) {
            this.aconst_null();
        } else {
            this.mv.visitLdcInsn(handle);
        }
    }

    public void push(ConstantDynamic constantDynamic) {
        if (constantDynamic == null) {
            this.aconst_null();
        } else {
            this.mv.visitLdcInsn(constantDynamic);
        }
    }

    public int getArgIndex(int arg) {
        Type[] argumentTypes = this.getArgumentTypes();
        int index = (this.access & 8) == 0 ? 1 : 0;
        for (int i = 0; i < arg; ++i) {
            index += argumentTypes[i].getSize();
        }
        return index;
    }

    public void loadInsn(Type type, int index) {
        this.mv.visitVarInsn(type.getOpcode(21), index);
    }

    public void storeInsn(Type type, int index) {
        this.mv.visitVarInsn(type.getOpcode(54), index);
    }

    public void loadThis() {
        if ((this.access & 8) != 0) {
            throw new IllegalStateException("no 'this' pointer within static method");
        }
        this.mv.visitVarInsn(25, 0);
    }

    public void loadArg(int arg) {
        this.loadInsn(this.argumentTypes[arg], this.getArgIndex(arg));
    }

    public void loadArgs(int arg, int count) {
        int index = this.getArgIndex(arg);
        Type[] argumentTypes = this.argumentTypes;
        for (int i = 0; i < count; ++i) {
            Type argumentType = argumentTypes[arg + i];
            this.loadInsn(argumentType, index);
            index += argumentType.getSize();
        }
    }

    public void loadArgs() {
        this.loadArgs(0, this.argumentTypes.length);
    }

    public void loadArgArray() {
        Type[] argumentTypes = this.argumentTypes;
        this.push(argumentTypes.length);
        this.newArray(Type.TYPE_OBJECT);
        for (int i = 0; i < argumentTypes.length; ++i) {
            this.dup();
            this.push(i);
            this.loadArg(i);
            this.box(argumentTypes[i]);
            this.arrayStore(Type.TYPE_OBJECT);
        }
    }

    public void storeArg(int arg) {
        this.storeInsn(this.argumentTypes[arg], this.getArgIndex(arg));
    }

    public Type getLocalType(int local) {
        return this.localTypes.get(local - this.firstLocal);
    }

    @Override
    protected void setLocalType(int local, Type type) {
        int index = local - this.firstLocal;
        while (this.localTypes.size() < index + 1) {
            this.localTypes.add(null);
        }
        this.localTypes.set(index, type);
    }

    public void loadLocal(Local local) {
        this.loadInsn(local.type, local.index);
    }

    public void loadLocal(int local) {
        this.loadInsn(this.getLocalType(local), local);
    }

    public void loadLocal(int local, Type type) {
        this.setLocalType(local, type);
        this.loadInsn(type, local);
    }

    public void storeLocal(Local local) {
        this.storeInsn(local.type, local.index);
    }

    public void storeLocal(int local) {
        this.storeInsn(this.getLocalType(local), local);
    }

    public void storeLocal(int local, Type type) {
        this.setLocalType(local, type);
        this.storeInsn(type, local);
    }

    public void arrayLoad(Type type) {
        this.mv.visitInsn(type.getOpcode(46));
    }

    public void arrayStore(Type type) {
        this.mv.visitInsn(type.getOpcode(79));
    }

    public void aastore() {
        this.mv.visitInsn(83);
    }

    public void aaload(int index) {
        this.push(index);
        this.aaload();
    }

    public void aaload() {
        this.mv.visitInsn(50);
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void pop2() {
        this.mv.visitInsn(88);
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void dup2() {
        this.mv.visitInsn(92);
    }

    public void dupX1() {
        this.mv.visitInsn(90);
    }

    public void dupX2() {
        this.mv.visitInsn(91);
    }

    public void dup2X1() {
        this.mv.visitInsn(93);
    }

    public void dup2X2() {
        this.mv.visitInsn(94);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void swap(Type prev, Type type) {
        if (type.getSize() == 1) {
            if (prev.getSize() == 1) {
                this.swap();
            } else {
                this.dupX2();
                this.pop();
            }
        } else if (prev.getSize() == 1) {
            this.dup2X1();
            this.pop2();
        } else {
            this.dup2X2();
            this.pop2();
        }
    }

    public void math(int op, Type type) {
        this.mv.visitInsn(type.getOpcode(op));
    }

    public void not() {
        this.mv.visitInsn(4);
        this.mv.visitInsn(130);
    }

    public void iinc(Local local, int amount) {
        this.mv.visitIincInsn(local.index, amount);
    }

    public void iinc(int local, int amount) {
        this.mv.visitIincInsn(local, amount);
    }

    public void cast(Type from, Type to) {
        if (from != to) {
            if (from.getSort() < 1 || from.getSort() > 8 || to.getSort() < 1 || to.getSort() > 8) {
                throw new IllegalArgumentException("Cannot cast from " + from + " to " + to);
            }
            InstructionAdapter.cast(this.mv, from, to);
        }
    }

    public void box(Type type) {
        if (type.isPrimitive()) {
            if (type == Type.VOID_TYPE) {
                this.aconst_null();
            } else {
                Type boxedType = type.getBoxedType();
                this.newInstance(boxedType);
                if (type.getSize() == 2) {
                    this.dupX2();
                    this.dupX2();
                    this.pop();
                } else {
                    this.dupX1();
                    this.swap();
                }
                this.invokeConstructor(boxedType, MethodSignature.forConstructor(type));
            }
        }
    }

    public void valueOf(Type type) {
        if (type.isPrimitive()) {
            if (type == Type.VOID_TYPE) {
                this.aconst_null();
            } else {
                Type boxedType = type.getBoxedType();
                this.invokeStatic(boxedType, new MethodSignature(boxedType, "valueOf", type));
            }
        }
    }

    public void unbox(Type type) {
        MethodSignature unboxMethod;
        Type boxedType = Type.TYPE_NUMBER;
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                boxedType = Type.TYPE_CHARACTER;
                unboxMethod = MethodSignature.CHAR_VALUE;
                break;
            }
            case 1: {
                boxedType = Type.TYPE_BOOLEAN;
                unboxMethod = MethodSignature.BOOLEAN_VALUE;
                break;
            }
            case 8: {
                unboxMethod = MethodSignature.DOUBLE_VALUE;
                break;
            }
            case 6: {
                unboxMethod = MethodSignature.FLOAT_VALUE;
                break;
            }
            case 7: {
                unboxMethod = MethodSignature.LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                unboxMethod = MethodSignature.INT_VALUE;
                break;
            }
            default: {
                unboxMethod = null;
            }
        }
        if (unboxMethod == null) {
            this.checkCast(type);
        } else {
            this.checkCast(boxedType);
            this.invokeVirtual(boxedType, unboxMethod);
        }
    }

    public Label newLabel() {
        return new Label();
    }

    public void mark(Label label) {
        this.mv.visitLabel(label);
    }

    public Label mark() {
        Label label = new Label();
        this.mv.visitLabel(label);
        return label;
    }

    public void ifCmp(Type type, int mode, Label label) {
        switch (type.getSort()) {
            case 7: {
                this.mv.visitInsn(148);
                break;
            }
            case 8: {
                this.mv.visitInsn(mode == 156 || mode == 157 ? 151 : 152);
                break;
            }
            case 6: {
                this.mv.visitInsn(mode == 156 || mode == 157 ? 149 : 150);
                break;
            }
            case 9: 
            case 10: {
                if (mode == 153) {
                    this.mv.visitJumpInsn(165, label);
                    return;
                }
                if (mode == 154) {
                    this.mv.visitJumpInsn(166, label);
                    return;
                }
                throw new IllegalArgumentException("Bad comparison for type " + type);
            }
            default: {
                int intOp = switch (mode) {
                    case 153 -> 159;
                    case 154 -> 160;
                    case 156 -> 162;
                    case 155 -> 161;
                    case 158 -> 164;
                    case 157 -> 163;
                    default -> throw new IllegalArgumentException("Bad comparison mode " + mode);
                };
                this.mv.visitJumpInsn(intOp, label);
                return;
            }
        }
        this.mv.visitJumpInsn(mode, label);
    }

    public void ifICmp(int mode, Label label) {
        this.ifCmp(Type.INT_TYPE, mode, label);
    }

    public void ifZCmp(int mode, Label label) {
        this.mv.visitJumpInsn(mode, label);
    }

    public void ifJump(int mode, Label label) {
        this.mv.visitJumpInsn(mode, label);
    }

    public void ifIcmp(int mode, Label label) {
        this.ifCmp(Type.INT_TYPE, mode, label);
    }

    public void ifNull(Label label) {
        this.mv.visitJumpInsn(198, label);
    }

    public void ifNonNull(Label label) {
        this.mv.visitJumpInsn(199, label);
    }

    public void goTo(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    public void ret(int local) {
        this.mv.visitVarInsn(169, local);
    }

    public void tableSwitch(int[] keys, TableSwitchGenerator generator) {
        float density = keys.length == 0 ? 0.0f : (float)keys.length / (float)(keys[keys.length - 1] - keys[0] + 1);
        this.tableSwitch(keys, generator, density >= 0.5f);
    }

    public void tableSwitch(int[] keys, TableSwitchGenerator generator, boolean useTable) {
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i] >= keys[i - 1]) continue;
            throw new IllegalArgumentException("keys must be sorted in ascending order");
        }
        Label defaultLabel = this.newLabel();
        Label endLabel = this.newLabel();
        if (keys.length > 0) {
            int numKeys = keys.length;
            if (useTable) {
                int min = keys[0];
                int max = keys[numKeys - 1];
                int range = max - min + 1;
                Object[] labels = new Label[range];
                Arrays.fill(labels, defaultLabel);
                for (int key : keys) {
                    labels[key - min] = this.newLabel();
                }
                this.mv.visitTableSwitchInsn(min, max, defaultLabel, (Label[])labels);
                for (int i = 0; i < range; ++i) {
                    Object label = labels[i];
                    if (label == defaultLabel) continue;
                    this.mark((Label)label);
                    generator.generateCase(i + min, endLabel);
                }
            } else {
                int i;
                Label[] labels = new Label[numKeys];
                for (i = 0; i < numKeys; ++i) {
                    labels[i] = this.newLabel();
                }
                this.mv.visitLookupSwitchInsn(defaultLabel, keys, labels);
                for (i = 0; i < numKeys; ++i) {
                    this.mark(labels[i]);
                    generator.generateCase(keys[i], endLabel);
                }
            }
        }
        this.mark(defaultLabel);
        generator.generateDefault();
        this.mark(endLabel);
    }

    public void returnValue() {
        this.mv.visitInsn(this.returnType.getOpcode(172));
    }

    public void fieldInsn(int opcode, Type ownerType, String name, Type fieldType) {
        this.mv.visitFieldInsn(opcode, ownerType.getInternalName(), name, fieldType.getDescriptor());
    }

    public void getStatic(Type owner, String name, Type type) {
        this.fieldInsn(178, owner, name, type);
    }

    public void putStatic(Type owner, String name, Type type) {
        this.fieldInsn(179, owner, name, type);
    }

    public void getField(Type owner, String name, Type type) {
        this.fieldInsn(180, owner, name, type);
    }

    public void putField(Type owner, String name, Type type) {
        this.fieldInsn(181, owner, name, type);
    }

    public void invokeInsn(int opcode, Type type, MethodSignature method, boolean isInterface) {
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        this.mv.visitMethodInsn(opcode, owner, method.getName(), method.getDescriptor(), isInterface);
    }

    public void invokeVirtual(Type owner, MethodSignature method) {
        this.invokeInsn(182, owner, method, false);
    }

    public void invokeConstructor(Type type) {
        this.invokeInsn(183, type, MethodSignature.EMPTY_CONSTRUCTOR, false);
    }

    public void invokeConstructor(Type type, MethodSignature method) {
        this.invokeInsn(183, type, method, false);
    }

    public void invokeStatic(Type owner, MethodSignature method) {
        this.invokeInsn(184, owner, method, false);
    }

    public void invokeInterface(Type owner, MethodSignature method) {
        this.invokeInsn(185, owner, method, true);
    }

    public void invokeDynamic(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.mv.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    protected void typeInsn(int opcode, Type type) {
        this.mv.visitTypeInsn(opcode, type.getInternalName());
    }

    public void newInstance(Type type) {
        this.typeInsn(187, type);
    }

    public void newArray() {
        this.newArray(Type.TYPE_OBJECT);
    }

    public void newArray(Type type) {
        InstructionAdapter.newArray(this.mv, type);
    }

    public void arrayLength() {
        this.mv.visitInsn(190);
    }

    public void throwException() {
        this.mv.visitInsn(191);
    }

    public void throwException(Type type, String message) {
        this.newInstance(type);
        this.dup();
        this.push(message);
        this.invokeConstructor(type, MethodSignature.constructWithString);
        this.throwException();
    }

    public void checkCast(Type type) {
        if (!type.equals(Type.TYPE_OBJECT)) {
            this.typeInsn(192, type);
        }
    }

    public void instanceOf(Type type) {
        this.typeInsn(193, type);
    }

    public void monitorEnter() {
        this.mv.visitInsn(194);
    }

    public void monitorExit() {
        this.mv.visitInsn(195);
    }

    public void endMethod() {
        if ((this.access & 0x400) == 0) {
            this.mv.visitMaxs(0, 0);
        }
        this.mv.visitEnd();
    }

    public void catchException(Label start, Label end, Type exception) {
        Label catchLabel = new Label();
        if (exception == null) {
            this.mv.visitTryCatchBlock(start, end, catchLabel, null);
        } else {
            this.mv.visitTryCatchBlock(start, end, catchLabel, exception.getInternalName());
        }
        this.mark(catchLabel);
    }
}

