/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.beans;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import java.beans.PropertyDescriptor;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;

public class BeanGenerator
extends AbstractClassGenerator<Object> {
    private boolean classOnly;
    private Class<?> superclass;
    private final HashMap<String, Type> props = new HashMap();

    public BeanGenerator() {
        super(BeanGenerator.class);
    }

    public void setSuperclass(Class<?> superclass) {
        if (superclass != null && superclass.equals(Object.class)) {
            superclass = null;
        }
        this.setNeighbor(superclass);
        this.superclass = superclass;
    }

    public void addProperty(String name, Class<?> type) {
        if (this.props.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate property name \"" + name + "\"");
        }
        this.props.put(name, Type.fromClass(type));
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        return ReflectionUtils.getProtectionDomain(this.superclass);
    }

    public Object create() {
        this.classOnly = false;
        return this.createHelper();
    }

    public Object createClass() {
        this.classOnly = true;
        return this.createHelper();
    }

    private Object createHelper() {
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        }
        String superName = this.superclass != null ? this.superclass.getName() : "java.lang.Object";
        BeanGeneratorKey key = new BeanGeneratorKey(superName, this.props);
        return super.create(key);
    }

    @Override
    public void generateClass(ClassVisitor v) {
        HashMap<String, Type> props = this.props;
        int size = props.size();
        Type[] types = new Type[size];
        int i = 0;
        for (Map.Entry entry : props.entrySet()) {
            types[i++] = (Type)entry.getValue();
        }
        ClassEmitter ce = new ClassEmitter(v);
        ce.beginClass(52, 1, this.getClassName(), this.superclass != null ? Type.fromClass(this.superclass) : Type.TYPE_OBJECT, null, new Type[0]);
        EmitUtils.nullConstructor(ce);
        EmitUtils.addProperties(ce, StringUtils.toStringArray(props.keySet()), types);
        ce.endClass();
    }

    @Override
    protected Object firstInstance(Class<Object> type) {
        if (this.classOnly) {
            return type;
        }
        return ReflectionUtils.newInstance(type);
    }

    @Override
    protected Object nextInstance(Object instance) {
        Class<?> protoclass;
        Class<?> clazz = protoclass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        return ReflectionUtils.newInstance(protoclass);
    }

    public static void addProperties(BeanGenerator gen, Map<String, Class<?>> props) {
        props.forEach(gen::addProperty);
    }

    public static void addProperties(BeanGenerator gen, Class<?> type) {
        BeanGenerator.addProperties(gen, CglibReflectUtils.getBeanProperties(type));
    }

    public static void addProperties(BeanGenerator gen, PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            gen.addProperty(descriptor.getName(), descriptor.getPropertyType());
        }
    }

    record BeanGeneratorKey(String superclass, Map<String, Type> props) {
    }
}

