/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.beans;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.Converter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.util.ReflectionUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.HashMap;

public abstract class BeanCopier {
    private static final Type CONVERTER = Type.fromClass(Converter.class);
    private static final Type BEAN_COPIER = Type.fromClass(BeanCopier.class);
    private static final MethodSignature COPY = new MethodSignature(Type.VOID_TYPE, "copy", Type.TYPE_OBJECT, Type.TYPE_OBJECT, CONVERTER);
    private static final MethodSignature CONVERT = MethodSignature.from("Object convert(Object, Class, Object)");

    public static BeanCopier create(Class source, Class target, boolean useConverter) {
        return new Generator(source, target, useConverter).create();
    }

    public abstract void copy(Object var1, Object var2, Converter var3);

    public static class Generator
    extends AbstractClassGenerator {
        private final Class source;
        private final Class target;
        private final boolean useConverter;

        public Generator(Class source, Class target, boolean useConverter) {
            super(BeanCopier.class);
            if (!Modifier.isPublic(source.getModifiers())) {
                this.setNamePrefix(source.getName());
            }
            if (!Modifier.isPublic(target.getModifiers())) {
                this.setNamePrefix(target.getName());
            }
            this.setNeighbor(source);
            this.source = source;
            this.target = target;
            this.useConverter = useConverter;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.source.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.source);
        }

        public BeanCopier create() {
            return (BeanCopier)super.create(new BeanCopierKey(this.source.getName(), this.target.getName(), this.useConverter));
        }

        @Override
        public void generateClass(ClassVisitor v) {
            Type sourceType = Type.fromClass(this.source);
            Type targetType = Type.fromClass(this.target);
            ClassEmitter ce = new ClassEmitter(v);
            ce.beginClass(52, 1, this.getClassName(), BEAN_COPIER, null, "<cglibGenerated>");
            EmitUtils.nullConstructor(ce);
            CodeEmitter e = ce.beginMethod(1, COPY, new Type[0]);
            PropertyDescriptor[] getters = CglibReflectUtils.getBeanGetters(this.source);
            PropertyDescriptor[] setters = CglibReflectUtils.getBeanSetters(this.target);
            HashMap<String, PropertyDescriptor> names = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : getters) {
                names.put(propertyDescriptor.getName(), propertyDescriptor);
            }
            Local targetLocal = e.newLocal();
            Local sourceLocal = e.newLocal();
            if (this.useConverter) {
                e.loadArg(1);
                e.checkCast(targetType);
                e.storeLocal(targetLocal);
                e.loadArg(0);
                e.checkCast(sourceType);
                e.storeLocal(sourceLocal);
            } else {
                e.loadArg(1);
                e.checkCast(targetType);
                e.loadArg(0);
                e.checkCast(sourceType);
            }
            for (PropertyDescriptor setter : setters) {
                PropertyDescriptor getter = (PropertyDescriptor)names.get(setter.getName());
                if (getter == null) continue;
                MethodInfo read = MethodInfo.from(getter.getReadMethod());
                MethodInfo write = MethodInfo.from(setter.getWriteMethod());
                if (this.useConverter) {
                    Type setterType = write.getSignature().getArgumentTypes()[0];
                    e.loadLocal(targetLocal);
                    e.loadArg(2);
                    e.loadLocal(sourceLocal);
                    e.invoke(read);
                    e.box(read.getSignature().getReturnType());
                    EmitUtils.loadClass(e, setterType);
                    e.push(write.getSignature().getName());
                    e.invokeInterface(CONVERTER, CONVERT);
                    e.unbox_or_zero(setterType);
                    e.invoke(write);
                    continue;
                }
                if (!Generator.compatible(getter, setter)) continue;
                e.dup2();
                e.invoke(read);
                e.invoke(write);
            }
            e.returnValue();
            e.end_method();
            ce.endClass();
        }

        private static boolean compatible(PropertyDescriptor getter, PropertyDescriptor setter) {
            return setter.getPropertyType().isAssignableFrom(getter.getPropertyType());
        }

        protected Object firstInstance(Class type) {
            return ReflectionUtils.newInstance(type);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    record BeanCopierKey(String source, String target, boolean useConverter) {
    }
}

