/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode;

import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ObjectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;

public final class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int FLOAT = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int ARRAY = 9;
    public static final int OBJECT = 10;
    public static final int METHOD = 11;
    private static final int INTERNAL = 12;
    private static final String PRIMITIVE_DESCRIPTORS = "VZCBSIFJD";
    public static final Type VOID_TYPE = new Type(0, "VZCBSIFJD", 0, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, "VZCBSIFJD", 1, 2);
    public static final Type CHAR_TYPE = new Type(2, "VZCBSIFJD", 2, 3);
    public static final Type BYTE_TYPE = new Type(3, "VZCBSIFJD", 3, 4);
    public static final Type SHORT_TYPE = new Type(4, "VZCBSIFJD", 4, 5);
    public static final Type INT_TYPE = new Type(5, "VZCBSIFJD", 5, 6);
    public static final Type FLOAT_TYPE = new Type(6, "VZCBSIFJD", 6, 7);
    public static final Type LONG_TYPE = new Type(7, "VZCBSIFJD", 7, 8);
    public static final Type DOUBLE_TYPE = new Type(8, "VZCBSIFJD", 8, 9);
    private static final HashMap<String, String> PRIMITIVE_TYPE_DESCRIPTORS;
    public static final Type TYPE_TYPE;
    public static final Type TYPE_CONSTANT;
    public static final Type TYPE_OBJECT_ARRAY;
    public static final Type TYPE_CLASS_ARRAY;
    public static final Type TYPE_STRING_ARRAY;
    public static final Type TYPE_ERROR;
    public static final Type TYPE_SYSTEM;
    public static final Type TYPE_LONG;
    public static final Type TYPE_BYTE;
    public static final Type TYPE_CLASS;
    public static final Type TYPE_FLOAT;
    public static final Type TYPE_SHORT;
    public static final Type TYPE_DOUBLE;
    public static final Type TYPE_STRING;
    public static final Type TYPE_NUMBER;
    public static final Type TYPE_BOOLEAN;
    public static final Type TYPE_INTEGER;
    public static final Type TYPE_CHARACTER;
    public static final Type TYPE_THROWABLE;
    public static final Type TYPE_CLASS_LOADER;
    public static final Type TYPE_STRING_BUFFER;
    public static final Type TYPE_RUNTIME_EXCEPTION;
    public static final Type TYPE_SIGNATURE;
    public static final Type TYPE_OBJECT;
    public static final Type[] EMPTY_ARRAY;
    private final int sort;
    private final String valueBuffer;
    private final int valueBegin;
    private final int valueEnd;

    private Type(int sort, String valueBuffer, int valueBegin, int valueEnd) {
        this.sort = sort;
        this.valueBuffer = valueBuffer;
        this.valueBegin = valueBegin;
        this.valueEnd = valueEnd;
    }

    public static Type parse(String s) {
        return Type.fromDescriptor(Type.getDescriptor(s));
    }

    @Nullable
    public static String resolvePrimitiveTypeDescriptor(String type) {
        return PRIMITIVE_TYPE_DESCRIPTORS.get(type);
    }

    public static Type fromDescriptor(String typeDescriptor) {
        return Type.getTypeInternal(typeDescriptor, 0, typeDescriptor.length());
    }

    public static Type fromClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            if (clazz == Long.TYPE) {
                return LONG_TYPE;
            }
            throw new AssertionError();
        }
        return Type.fromDescriptor(Type.getDescriptor(clazz));
    }

    public static Type fromConstructor(Constructor<?> constructor) {
        return Type.fromDescriptor(Type.getConstructorDescriptor(constructor));
    }

    public static Type fromMethod(Method method) {
        return Type.fromDescriptor(Type.getMethodDescriptor(method));
    }

    public Type getElementType() {
        int numDimensions = this.getDimensions();
        return Type.getTypeInternal(this.valueBuffer, this.valueBegin + numDimensions, this.valueEnd);
    }

    public static Type fromInternalName(String internalName) {
        return new Type(internalName.charAt(0) == '[' ? 9 : 12, internalName, 0, internalName.length());
    }

    public static Type[] fromInternalNames(String[] names) {
        if (names == null) {
            return null;
        }
        Type[] types = new Type[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = Type.fromInternalName(names[i]);
        }
        return types;
    }

    public static Type[] getObjectTypes(String[] internalNames) {
        if (internalNames == null) {
            return null;
        }
        Type[] ret = new Type[internalNames.length];
        int i = 0;
        for (String internalName : internalNames) {
            ret[i++] = Type.fromInternalName(internalName);
        }
        return ret;
    }

    public static Type[] getExceptionTypes(Member member) {
        if (member instanceof Executable) {
            return Type.getTypes(((Executable)member).getExceptionTypes());
        }
        throw new IllegalArgumentException(member + " is not a Executable");
    }

    public static Type fromMethod(String methodDescriptor) {
        return new Type(11, methodDescriptor, 0, methodDescriptor.length());
    }

    public static Type fromMethod(Type returnType, Type ... argumentTypes) {
        return Type.fromDescriptor(Type.getMethodDescriptor(returnType, argumentTypes));
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getDescriptor());
    }

    public static Type[] getArgumentTypes(String methodDescriptor) {
        int numArgumentTypes = 0;
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
            }
            ++numArgumentTypes;
        }
        if (numArgumentTypes == 0) {
            return EMPTY_ARRAY;
        }
        Type[] argumentTypes = new Type[numArgumentTypes];
        currentOffset = 1;
        int currentArgumentTypeIndex = 0;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            int currentArgumentTypeOffset = currentOffset;
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
            }
            argumentTypes[currentArgumentTypeIndex++] = Type.getTypeInternal(methodDescriptor, currentArgumentTypeOffset, currentOffset);
        }
        return argumentTypes;
    }

    public static Type[] getArgumentTypes(Method method) {
        Class<?>[] classes = method.getParameterTypes();
        Type[] types = new Type[classes.length];
        for (int i = classes.length - 1; i >= 0; --i) {
            types[i] = Type.fromClass(classes[i]);
        }
        return types;
    }

    public Type getReturnType() {
        return Type.forReturnType(this.getDescriptor());
    }

    public static Type forReturnType(String methodDescriptor) {
        return Type.getTypeInternal(methodDescriptor, Type.getReturnTypeOffset(methodDescriptor), methodDescriptor.length());
    }

    public static Type forReturnType(Method method) {
        return Type.fromClass(method.getReturnType());
    }

    static int getReturnTypeOffset(String methodDescriptor) {
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) != 'L') continue;
            int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
            currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
        }
        return currentOffset + 1;
    }

    private static Type getTypeInternal(String descriptorBuffer, int descriptorBegin, int descriptorEnd) {
        return switch (descriptorBuffer.charAt(descriptorBegin)) {
            case 'V' -> VOID_TYPE;
            case 'Z' -> BOOLEAN_TYPE;
            case 'C' -> CHAR_TYPE;
            case 'B' -> BYTE_TYPE;
            case 'S' -> SHORT_TYPE;
            case 'I' -> INT_TYPE;
            case 'F' -> FLOAT_TYPE;
            case 'J' -> LONG_TYPE;
            case 'D' -> DOUBLE_TYPE;
            case '[' -> new Type(9, descriptorBuffer, descriptorBegin, descriptorEnd);
            case 'L' -> new Type(10, descriptorBuffer, descriptorBegin + 1, descriptorEnd - 1);
            case '(' -> new Type(11, descriptorBuffer, descriptorBegin, descriptorEnd);
            default -> throw new IllegalArgumentException("Invalid descriptor: " + descriptorBuffer);
        };
    }

    public String getClassName() {
        return switch (this.sort) {
            case 5 -> "int";
            case 0 -> "void";
            case 2 -> "char";
            case 3 -> "byte";
            case 7 -> "long";
            case 4 -> "short";
            case 6 -> "float";
            case 8 -> "double";
            case 1 -> "boolean";
            case 10, 12 -> this.valueBuffer.substring(this.valueBegin, this.valueEnd).replace('/', '.');
            case 9 -> this.getElementType().getClassName() + "[]".repeat(Math.max(0, this.getDimensions()));
            default -> throw new AssertionError();
        };
    }

    public String getInternalName() {
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public String getDescriptor() {
        if (this.sort == 10) {
            return this.valueBuffer.substring(this.valueBegin - 1, this.valueEnd + 1);
        }
        if (this.sort == 12) {
            return "L" + this.valueBuffer.substring(this.valueBegin, this.valueEnd) + ";";
        }
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public static String getDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        Type.appendDescriptor(clazz, stringBuilder);
        return stringBuilder.toString();
    }

    public static String getConstructorDescriptor(Constructor<?> constructor) {
        Class<?>[] parameters;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> parameter : parameters = constructor.getParameterTypes()) {
            Type.appendDescriptor(parameter, stringBuilder);
        }
        return stringBuilder.append(")V").toString();
    }

    public static String getMethodDescriptor(Type returnType, Type ... argumentTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Type argumentType : argumentTypes) {
            argumentType.appendDescriptor(stringBuilder);
        }
        stringBuilder.append(')');
        returnType.appendDescriptor(stringBuilder);
        return stringBuilder.toString();
    }

    public static String getMethodDescriptor(Method method) {
        Class<?>[] parameters;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (Class<?> parameter : parameters = method.getParameterTypes()) {
            Type.appendDescriptor(parameter, stringBuilder);
        }
        stringBuilder.append(')');
        Type.appendDescriptor(method.getReturnType(), stringBuilder);
        return stringBuilder.toString();
    }

    public static String getDescriptor(String parameterTypes) {
        return Type.getDescriptor(parameterTypes, 0, parameterTypes.length(), false);
    }

    @NonNull
    public static String getDescriptor(String parameterTypes, int startIdx, int endIdx, boolean defaultPackage) {
        StringBuilder argDescriptor = new StringBuilder(parameterTypes.length() + 16);
        int splitIndex = parameterTypes.indexOf(44);
        while (splitIndex != -1) {
            argDescriptor.append(Type.getDescriptor(parameterTypes.substring(startIdx, splitIndex).trim(), defaultPackage));
            startIdx = splitIndex + 1;
            splitIndex = parameterTypes.indexOf(44, startIdx);
        }
        argDescriptor.append(Type.getDescriptor(parameterTypes.substring(startIdx, endIdx).trim(), defaultPackage));
        return argDescriptor.toString();
    }

    public static String getDescriptor(String type, boolean defaultPackage) {
        if ("".equals(type)) {
            return type;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int arrayBracketsIndex = 0;
        while ((arrayBracketsIndex = type.indexOf("[]", arrayBracketsIndex) + 1) > 0) {
            stringBuilder.append('[');
        }
        String elementType = type.substring(0, type.length() - stringBuilder.length() * 2);
        String descriptor = PRIMITIVE_TYPE_DESCRIPTORS.get(elementType);
        if (descriptor != null) {
            stringBuilder.append(descriptor);
        } else {
            stringBuilder.append('L');
            if (elementType.indexOf(46) < 0) {
                if (!defaultPackage) {
                    stringBuilder.append("java/lang/");
                }
                stringBuilder.append(elementType);
            } else {
                stringBuilder.append(elementType.replace('.', '/'));
            }
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    private void appendDescriptor(StringBuilder stringBuilder) {
        if (this.sort == 10) {
            stringBuilder.append(this.valueBuffer, this.valueBegin - 1, this.valueEnd + 1);
        } else if (this.sort == 12) {
            stringBuilder.append('L').append(this.valueBuffer, this.valueBegin, this.valueEnd).append(';');
        } else {
            stringBuilder.append(this.valueBuffer, this.valueBegin, this.valueEnd);
        }
    }

    private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            stringBuilder.append('[');
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            int descriptor;
            if (currentClass == Integer.TYPE) {
                descriptor = 73;
            } else if (currentClass == Void.TYPE) {
                descriptor = 86;
            } else if (currentClass == Boolean.TYPE) {
                descriptor = 90;
            } else if (currentClass == Byte.TYPE) {
                descriptor = 66;
            } else if (currentClass == Character.TYPE) {
                descriptor = 67;
            } else if (currentClass == Short.TYPE) {
                descriptor = 83;
            } else if (currentClass == Double.TYPE) {
                descriptor = 68;
            } else if (currentClass == Float.TYPE) {
                descriptor = 70;
            } else if (currentClass == Long.TYPE) {
                descriptor = 74;
            } else {
                throw new AssertionError();
            }
            stringBuilder.append((char)descriptor);
        } else {
            stringBuilder.append('L').append(Type.getInternalName(currentClass)).append(';');
        }
    }

    public Type getComponentType() {
        if (this.isArray()) {
            return Type.fromDescriptor(this.getDescriptor().substring(1));
        }
        throw new IllegalArgumentException("Type " + this + " is not an array");
    }

    public String emulateClassGetName() {
        if (this.isArray()) {
            return this.getDescriptor().replace('/', '.');
        }
        return this.getClassName();
    }

    public static String[] toInternalNames(Type ... types) {
        if (types == null) {
            return null;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i].getInternalName();
        }
        return names;
    }

    public Type getBoxedType() {
        return switch (this.getSort()) {
            case 2 -> TYPE_CHARACTER;
            case 1 -> TYPE_BOOLEAN;
            case 8 -> TYPE_DOUBLE;
            case 6 -> TYPE_FLOAT;
            case 7 -> TYPE_LONG;
            case 5 -> TYPE_INTEGER;
            case 4 -> TYPE_SHORT;
            case 3 -> TYPE_BYTE;
            default -> this;
        };
    }

    public Type getUnboxedType() {
        if (TYPE_INTEGER.equals(this)) {
            return INT_TYPE;
        }
        if (TYPE_BOOLEAN == this) {
            return BOOLEAN_TYPE;
        }
        if (TYPE_DOUBLE.equals(this)) {
            return DOUBLE_TYPE;
        }
        if (TYPE_LONG.equals(this)) {
            return LONG_TYPE;
        }
        if (TYPE_CHARACTER.equals(this)) {
            return CHAR_TYPE;
        }
        if (TYPE_BYTE.equals(this)) {
            return BYTE_TYPE;
        }
        if (TYPE_FLOAT.equals(this)) {
            return FLOAT_TYPE;
        }
        if (TYPE_SHORT.equals(this)) {
            return SHORT_TYPE;
        }
        return this;
    }

    public int getSort() {
        return this.sort == 12 ? 10 : this.sort;
    }

    public int getDimensions() {
        int numDimensions = 1;
        while (this.valueBuffer.charAt(this.valueBegin + numDimensions) == '[') {
            ++numDimensions;
        }
        return numDimensions;
    }

    public int getSize() {
        return switch (this.sort) {
            case 0 -> 0;
            case 7, 8 -> 2;
            case 1, 2, 3, 4, 5, 6, 9, 10, 12 -> 1;
            default -> throw new AssertionError();
        };
    }

    public int getArgumentsAndReturnSizes() {
        return Type.getArgumentsAndReturnSizes(this.getDescriptor());
    }

    public static int getArgumentsAndReturnSizes(String methodDescriptor) {
        int argumentsSize = 1;
        int currentOffset = 1;
        char currentChar = methodDescriptor.charAt(currentOffset);
        while (currentChar != ')') {
            if (currentChar == 'J' || currentChar == 'D') {
                ++currentOffset;
                argumentsSize += 2;
            } else {
                while (methodDescriptor.charAt(currentOffset) == '[') {
                    ++currentOffset;
                }
                if (methodDescriptor.charAt(currentOffset++) == 'L') {
                    int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                    currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
                }
                ++argumentsSize;
            }
            currentChar = methodDescriptor.charAt(currentOffset);
        }
        currentChar = methodDescriptor.charAt(currentOffset + 1);
        if (currentChar == 'V') {
            return argumentsSize << 2;
        }
        int returnSize = currentChar == 'J' || currentChar == 'D' ? 2 : 1;
        return argumentsSize << 2 | returnSize;
    }

    public int getOpcode(int opcode) {
        if (opcode == 46 || opcode == 79) {
            return switch (this.sort) {
                case 5 -> opcode;
                case 2 -> opcode + 6;
                case 7 -> opcode + 1;
                case 4 -> opcode + 7;
                case 6 -> opcode + 2;
                case 8 -> opcode + 3;
                case 1, 3 -> opcode + 5;
                case 9, 10, 12 -> opcode + 4;
                case 0, 11 -> throw new UnsupportedOperationException();
                default -> throw new AssertionError();
            };
        }
        switch (this.sort) {
            case 0: {
                if (opcode != 172) {
                    throw new UnsupportedOperationException();
                }
                return 177;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return opcode;
            }
            case 6: {
                return opcode + 2;
            }
            case 7: {
                return opcode + 1;
            }
            case 8: {
                return opcode + 3;
            }
            case 9: 
            case 10: 
            case 12: {
                if (opcode != 21 && opcode != 54 && opcode != 172) {
                    throw new UnsupportedOperationException();
                }
                return opcode + 4;
            }
            case 11: {
                throw new UnsupportedOperationException();
            }
        }
        throw new AssertionError();
    }

    public static Type[] array(Type ... items) {
        return items;
    }

    public static Type[] getTypes(Class<?> ... items) {
        if (items == null) {
            return null;
        }
        int i = 0;
        Type[] ret = new Type[items.length];
        for (Class<?> item : items) {
            ret[i++] = Type.fromClass(item);
        }
        return ret;
    }

    public static Type[] getTypes(String ... items) {
        if (items == null) {
            return null;
        }
        int i = 0;
        Type[] ret = new Type[items.length];
        for (String item : items) {
            ret[i++] = Type.fromDescriptor(item);
        }
        return ret;
    }

    public static int getStackSize(Type[] types) {
        int size = 0;
        for (Type type : types) {
            size += type.getSize();
        }
        return size;
    }

    public boolean isArray() {
        return this.sort == 9;
    }

    public boolean isPrimitive() {
        int sort = this.getSort();
        return sort != 9 && sort != 10;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        Type other = (Type)object;
        if ((this.sort == 12 ? 10 : this.sort) != (other.sort == 12 ? 10 : other.sort)) {
            return false;
        }
        int end = this.valueEnd;
        int begin = this.valueBegin;
        int otherBegin = other.valueBegin;
        if (end - begin != other.valueEnd - otherBegin) {
            return false;
        }
        int i = begin;
        int j = otherBegin;
        while (i < end) {
            if (this.valueBuffer.charAt(i) != other.valueBuffer.charAt(j)) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 13 * (this.sort == 12 ? 10 : this.sort);
        if (this.sort >= 9) {
            for (int i = this.valueBegin; i < this.valueEnd; ++i) {
                hashCode = 17 * (hashCode + this.valueBuffer.charAt(i));
            }
        }
        return hashCode;
    }

    public String toString() {
        return this.getDescriptor();
    }

    public static Type[] add(Type[] types, Type extra) {
        return Type.add(types, extra, false);
    }

    public static Type[] add(Type[] types, Type extra, boolean justAdd) {
        if (ObjectUtils.isEmpty(types)) {
            return new Type[]{extra};
        }
        if (!justAdd && ObjectUtils.containsElement(types, extra)) {
            return types;
        }
        Type[] copy = new Type[types.length + 1];
        System.arraycopy(types, 0, copy, 0, types.length);
        copy[types.length] = extra;
        return copy;
    }

    public static Type[] add(Type[] t1, Type ... t2) {
        if (ObjectUtils.isEmpty(t2)) {
            return t1;
        }
        Type[] all = new Type[t1.length + t2.length];
        System.arraycopy(t1, 0, all, 0, t1.length);
        System.arraycopy(t2, 0, all, t1.length, t2.length);
        return all;
    }

    static {
        HashMap<String, String> descriptors = new HashMap<String, String>();
        descriptors.put("void", "V");
        descriptors.put("byte", "B");
        descriptors.put("char", "C");
        descriptors.put("double", "D");
        descriptors.put("float", "F");
        descriptors.put("int", "I");
        descriptors.put("long", "J");
        descriptors.put("short", "S");
        descriptors.put("boolean", "Z");
        PRIMITIVE_TYPE_DESCRIPTORS = descriptors;
        TYPE_TYPE = Type.fromClass(Type.class);
        TYPE_CONSTANT = Type.fromClass(Constant.class);
        TYPE_OBJECT_ARRAY = Type.fromInternalName("[Ljava/lang/Object;");
        TYPE_CLASS_ARRAY = Type.fromInternalName("[Ljava/lang/Class;");
        TYPE_STRING_ARRAY = Type.fromInternalName("[Ljava/lang/String;");
        TYPE_ERROR = Type.fromInternalName("java/lang/Error");
        TYPE_SYSTEM = Type.fromInternalName("java/lang/System");
        TYPE_LONG = Type.fromInternalName("java/lang/Long");
        TYPE_BYTE = Type.fromInternalName("java/lang/Byte");
        TYPE_CLASS = Type.fromInternalName("java/lang/Class");
        TYPE_FLOAT = Type.fromInternalName("java/lang/Float");
        TYPE_SHORT = Type.fromInternalName("java/lang/Short");
        TYPE_DOUBLE = Type.fromInternalName("java/lang/Double");
        TYPE_STRING = Type.fromInternalName("java/lang/String");
        TYPE_NUMBER = Type.fromInternalName("java/lang/Number");
        TYPE_BOOLEAN = Type.fromInternalName("java/lang/Boolean");
        TYPE_INTEGER = Type.fromInternalName("java/lang/Integer");
        TYPE_CHARACTER = Type.fromInternalName("java/lang/Character");
        TYPE_THROWABLE = Type.fromInternalName("java/lang/Throwable");
        TYPE_CLASS_LOADER = Type.fromInternalName("java/lang/ClassLoader");
        TYPE_STRING_BUFFER = Type.fromInternalName("java/lang/StringBuffer");
        TYPE_RUNTIME_EXCEPTION = Type.fromInternalName("java/lang/RuntimeException");
        TYPE_SIGNATURE = Type.fromClass(MethodSignature.class);
        TYPE_OBJECT = Type.fromInternalName("java/lang/Object");
        EMPTY_ARRAY = new Type[0];
    }
}

