/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode;

import cn.taketoday.bytecode.AnnotationValueHolder;
import cn.taketoday.bytecode.ByteVector;
import cn.taketoday.bytecode.SymbolTable;
import cn.taketoday.bytecode.Type;
import cn.taketoday.util.ClassUtils;

public final class ClassValueHolder
extends AnnotationValueHolder {
    private final Type descriptor;

    public ClassValueHolder(String descriptor) {
        this.descriptor = Type.fromDescriptor(descriptor);
    }

    public ClassValueHolder(Type descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Class<?> getInternal() {
        return ClassUtils.load(this.descriptor.getClassName());
    }

    @Override
    public Class<?> read() {
        return (Class)super.read();
    }

    @Override
    public void write(ByteVector annotation, SymbolTable symbolTable) {
        annotation.put12(99, symbolTable.addConstantUtf8(this.descriptor.getDescriptor()));
    }

    public static ClassValueHolder fromDescriptor(String typeDescriptor) {
        return new ClassValueHolder(typeDescriptor);
    }

    public Type getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "ClassValueHolder{descriptor=" + this.descriptor + "}";
    }
}

