/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode;

import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicInteger;

public class BytecodeCompiler {
    private static final int CLASSES_DEFINED_LIMIT = 100;
    private static final ConcurrentReferenceHashMap<ClassLoader, BytecodeCompiler> compilers = new ConcurrentReferenceHashMap();
    protected volatile ChildClassLoader childClassLoader;

    protected BytecodeCompiler(@Nullable ClassLoader classloader) {
        this.childClassLoader = new ChildClassLoader(classloader);
    }

    public <T> Class<T> compile(String className, byte[] classFile) {
        return this.loadClass(className, classFile);
    }

    public <T> Class<T> compile(byte[] classFile) {
        String className = ClassUtils.getClassName(classFile);
        return this.loadClass(className, classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Class<T> loadClass(String name, byte[] classFile) {
        ChildClassLoader ccl = this.childClassLoader;
        if (ccl.getClassesDefinedCount() >= 100) {
            BytecodeCompiler bytecodeCompiler = this;
            synchronized (bytecodeCompiler) {
                ChildClassLoader currentCcl = this.childClassLoader;
                if (ccl == currentCcl) {
                    this.childClassLoader = ccl = new ChildClassLoader(ccl.getParent());
                } else {
                    ccl = currentCcl;
                }
            }
        }
        return ccl.defineClass(name, classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytecodeCompiler getCompiler(@Nullable ClassLoader classLoader) {
        BytecodeCompiler compiler;
        if (classLoader == null) {
            classLoader = ClassUtils.getDefaultClassLoader();
        }
        if ((compiler = compilers.get(classLoader)) == null) {
            ConcurrentReferenceHashMap<ClassLoader, BytecodeCompiler> concurrentReferenceHashMap = compilers;
            synchronized (concurrentReferenceHashMap) {
                compiler = compilers.get(classLoader);
                if (compiler == null) {
                    compiler = new BytecodeCompiler(classLoader);
                    compilers.put(classLoader, compiler);
                }
            }
        }
        return compiler;
    }

    private static class ChildClassLoader
    extends URLClassLoader {
        private static final URL[] NO_URLS = new URL[0];
        private final AtomicInteger classesDefinedCount = new AtomicInteger(0);

        public ChildClassLoader(@Nullable ClassLoader classLoader) {
            super(NO_URLS, classLoader);
        }

        public Class<?> defineClass(String name, byte[] bytes) {
            Class<?> clazz = super.defineClass(name, bytes, 0, bytes.length);
            this.classesDefinedCount.incrementAndGet();
            return clazz;
        }

        public int getClassesDefinedCount() {
            return this.classesDefinedCount.get();
        }
    }
}

