/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.process;

import java.io.IOException;
import us.ihmc.process.LinuxProcess;
import us.ihmc.process.SchedulerAlgorithm;
import us.ihmc.realtime.RealtimeNative;

public class Scheduler {
    static native int setScheduler(int var0, int var1, int var2);

    static native int getScheduler(int var0);

    static native int getPriority(int var0);

    public static void setScheduler(LinuxProcess process, SchedulerAlgorithm scheduler, int priority) throws IOException {
        int pid = process == null ? 0 : process.getPid();
        int ret = Scheduler.setScheduler(pid, scheduler.getCOrdinal(), priority);
        if (ret < 0) {
            throw new IOException("Cannot set scheduler of pid " + pid + ". Error no: " + ret);
        }
    }

    public static SchedulerAlgorithm getScheduler(LinuxProcess process) throws IOException {
        int pid = process == null ? 0 : process.getPid();
        int sched = Scheduler.getScheduler(pid);
        if (sched < 0) {
            throw new IOException("Cannot get scheduler of pid " + pid + ". Error no: " + sched);
        }
        return SchedulerAlgorithm.fromCOrdinal(sched);
    }

    public static int getPriority(LinuxProcess process) throws IOException {
        int pid = process == null ? 0 : process.getPid();
        int priority = Scheduler.getPriority(pid);
        if (priority < 0) {
            throw new IOException("Cannot get priority of pid " + pid + ". Error no: " + priority);
        }
        return priority;
    }

    static {
        RealtimeNative.init();
    }
}

