/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.concurrent.dataStructures;

import us.ihmc.util.RealtimeTools;

public class ChangeListenerLongBuffer {
    private final boolean[] valueChanged;
    private final long[] values;

    public ChangeListenerLongBuffer(int capacity) {
        capacity = RealtimeTools.nextDivisibleBySixteen(capacity);
        this.valueChanged = new boolean[capacity];
        this.values = new long[capacity];
    }

    public void update(int index, long value) {
        this.valueChanged[index] = true;
        this.values[index] = value;
    }

    public boolean hasChangedAndReset(int index) {
        if (this.valueChanged[index]) {
            this.valueChanged[index] = false;
            return true;
        }
        return false;
    }

    public long getValue(int index) {
        return this.values[index];
    }

    public static class Builder
    implements us.ihmc.concurrent.Builder<ChangeListenerLongBuffer> {
        private final int capacity;

        public Builder(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public ChangeListenerLongBuffer newInstance() {
            return new ChangeListenerLongBuffer(this.capacity);
        }
    }
}

